/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.paronym;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.cogroo.analyzer.InitializationException;

public class ParonymList {
    private final Map<String, String> paronymsMap = Collections.unmodifiableMap(this.parseConfiguration());

    public Map<String, String> parseConfiguration() {
        InputStream input = ParonymList.class.getClassLoader().getResourceAsStream("rules/paronymy/paronym.txt");
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            while (reader.ready()) {
                String[] words;
                String line = reader.readLine().toLowerCase();
                if (line.length() <= 0 || line.charAt(0) == '#' || (words = line.split(",")) == null) continue;
                map.put(words[0], words[1]);
                map.put(words[1], words[0]);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new InitializationException("Enconding problem while reading the verbs.txt file", (Throwable)e);
        }
        catch (IOException e) {
            throw new InitializationException("Could not read the paronyms.txt file", (Throwable)e);
        }
    }

    public Map<String, String> getParonymsMap() {
        return this.paronymsMap;
    }
}

