/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.ruta.checker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.util.Span;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.checker.CheckDocument;
import org.cogroo.checker.GrammarChecker;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.Token;
import org.cogroo.ruta.tools.RuleParser;
import org.cogroo.ruta.uima.AEFactory;
import org.cogroo.ruta.uima.AnnotatorUtil;
import org.cogroo.ruta.uima.UimaCasAdapter;
import org.cogroo.tools.checker.AbstractTypedChecker;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.rules.applier.SuggestionBuilder;
import org.cogroo.tools.checker.rules.dictionary.CogrooTagDictionary;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.tools.checker.rules.model.TagMask;
import org.cogroo.tools.checker.rules.util.TagMaskUtils;

public class UIMAChecker
extends AbstractTypedChecker {
    private static final Logger LOGGER = Logger.getLogger(UIMAChecker.class);
    private final AnalysisEngine ae;
    private final UimaCasAdapter converter;
    private Type mProblemType;
    private Type mTokenType;
    private Feature mIDFeature;
    private Feature mSuggestionFeature;
    private final boolean developing = false;
    private static final Pattern SWAP = Pattern.compile("swap\\s+(\\d+)\\s+(\\d+)");
    private static final Pattern REPLACE_LEXEME = Pattern.compile("replace\\s+(\\d+)\\s+with\\s+'([^']+)'");
    private static final Pattern REPLACE_MAPPING = Pattern.compile("replace\\s+(\\d+)\\s+with\\s*\\{((\\s*'[^']+'\\s*=>\\s*'[^']+'\\s*)+)\\}");
    private static final Pattern REPLACE_MAPPING2 = Pattern.compile("'([^']+)'\\s*=>\\s*'([^']+)'");
    private static final Pattern REPLACE_TAGR = Pattern.compile("replace\\s+(\\d+)\\s+with\\s+(\\d+)\\s+in\\s+\\(((\\s*(number|gender|class|person|tense|mood)\\s*=\\s*[\\w-]+\\s*)+)\\)");
    private static final Pattern REPLACE_R = Pattern.compile("set\\s+\\((\\s*(gender|number|class|person|tense|mood)\\s*)+\\)\\s+of\\s+(\\d+)\\s+to\\s+match\\s+(\\d+)");
    private final HashSet<Integer> done = new HashSet();
    private final CogrooTagDictionary tagDictionary;
    private final SuggestionBuilder suggestionBuilder;
    private boolean typeSystemInitialized = false;

    public UIMAChecker(CogrooTagDictionary td) {
        this.tagDictionary = td;
        this.suggestionBuilder = new SuggestionBuilder(this.tagDictionary);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing UIMA Checker constructor.");
        }
        this.ae = AEFactory.createRutaAE();
        String fileName = "cogroo/ruta/Regras.txt";
        for (RuleDefinition ruleDef : RuleParser.getRuleDefinitionList(fileName)) {
            this.add(ruleDef);
        }
        this.converter = new UimaCasAdapter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"UIMA Checker constructor finished.");
        }
    }

    private static String applyCase(String s, int type) {
        switch (type) {
            case 0: {
                return s.toLowerCase();
            }
            case 1: {
                return Character.toUpperCase(s.charAt(0)) + s.substring(1);
            }
            case 2: {
                return s.toUpperCase();
            }
        }
        throw new IllegalArgumentException();
    }

    private static int getCase(String s) {
        char second;
        char first = s.charAt(0);
        char c = second = s.length() > 1 ? (char)s.charAt(1) : (char)'a';
        if (Character.isLowerCase(first)) {
            return 0;
        }
        if (Character.isUpperCase(second)) {
            return 2;
        }
        return 1;
    }

    public List<Mistake> check(Sentence sentence) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Checking sentence: '%s'", sentence));
        }
        this.done.add(sentence.getOffset());
        LinkedList<Mistake> mistakes = new LinkedList<Mistake>();
        try {
            CAS cas = this.ae.newCAS();
            cas.setDocumentText(sentence.getDocumentText());
            this.converter.populateCas(sentence.getTextSentence(), cas);
            this.ae.process(cas);
            TypeSystem typeSystem = cas.getTypeSystem();
            this.initTypeSystem(typeSystem);
            HashSet<Integer> processed = new HashSet<Integer>();
            AnnotationIndex problems = cas.getAnnotationIndex(this.mProblemType);
            for (AnnotationFS problem : problems) {
                if (processed.contains(problem.getBegin())) continue;
                processed.add(problem.getBegin());
                List<Token> coveredTokens = this.getTokens(sentence, problem.getBegin(), problem.getEnd());
                ArrayList<String> suggestions = new ArrayList<String>(4);
                String id = problem.getFeatureValueAsString(this.mIDFeature);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Found a mistake, id = " + id));
                }
                RuleDefinition rd = this.getRuleDefinition(id);
                System.out.println("\nID = '" + id + "'");
                System.out.println("TEXTO DO PROBLEM: '" + problem.getCoveredText() + "'");
                System.out.println("MENSAGEM: '" + rd.getMessage() + "'");
                System.out.println("MENSAGEM CURTA: '" + rd.getShortMessage() + "'");
                System.out.println("DESCRI\u00c7\u00c3O: '" + rd.getDescription() + "'");
                System.out.println("CATEGORIA: '" + rd.getCategory() + "'");
                System.out.println("GRUPO: '" + rd.getCategory() + "'");
                String suggestionRuta = problem.getFeatureValueAsString(this.mSuggestionFeature);
                System.out.println("SUGEST\u00c3O: '" + suggestionRuta + "'");
                for (Example example : rd.getExamples()) {
                    System.out.format("EXEMPLO   CORRETO: '%s'\nEXEMPLO INCORRETO: '%s'\n", example.getCorrect(), example.getIncorrect());
                }
                String[] originalTokens = problem.getCoveredText().split("(\\s+|-)");
                for (String sugPossibility : suggestionRuta.split("\\|")) {
                    String[] tokens = (String[])originalTokens.clone();
                    block5: for (String sugItem : sugPossibility.split(";")) {
                        TagMask tagMask;
                        String tagMaskStr;
                        int j;
                        int i;
                        Matcher m = SWAP.matcher(sugItem);
                        if (m.find()) {
                            i = Integer.parseInt(m.group(1)) - 1;
                            j = Integer.parseInt(m.group(2)) - 1;
                            String tmp = tokens[i];
                            tokens[i] = tokens[j];
                            tokens[j] = tmp;
                            continue;
                        }
                        m = REPLACE_LEXEME.matcher(sugItem);
                        if (m.find()) {
                            String text;
                            i = Integer.parseInt(m.group(1)) - 1;
                            tokens[i] = text = m.group(2);
                            continue;
                        }
                        m = REPLACE_MAPPING.matcher(sugItem);
                        if (m.find()) {
                            i = Integer.parseInt(m.group(1)) - 1;
                            Matcher m2 = REPLACE_MAPPING2.matcher(m.group(2));
                            while (m2.find()) {
                                if (!m2.group(1).equals(tokens[i])) continue;
                                tokens[i] = m2.group(2);
                                continue block5;
                            }
                            continue;
                        }
                        m = REPLACE_TAGR.matcher(sugItem);
                        if (m.find()) {
                            i = Integer.parseInt(m.group(1)) - 1;
                            j = Integer.parseInt(m.group(2)) - 1;
                            tagMaskStr = m.group(3);
                            tagMask = TagMaskUtils.parse((String)tagMaskStr);
                            tokens[i] = this.suggestionBuilder.getBestFlexedWord(coveredTokens.get(j), tagMask);
                            continue;
                        }
                        m = REPLACE_R.matcher(sugItem);
                        if (!m.find()) continue;
                        i = Integer.parseInt(m.group(3)) - 1;
                        j = Integer.parseInt(m.group(4)) - 1;
                        tagMaskStr = m.group(1);
                        tagMask = TagMaskUtils.createTagMaskFromToken((Token)coveredTokens.get(j), (String)tagMaskStr);
                        tokens[i] = this.suggestionBuilder.getBestFlexedWord(coveredTokens.get(i), tagMask);
                    }
                    StringBuilder s = new StringBuilder(UIMAChecker.applyCase(tokens[0], UIMAChecker.getCase(originalTokens[0])));
                    for (int k = 1; k < tokens.length; ++k) {
                        s.append(" " + UIMAChecker.applyCase(tokens[k], UIMAChecker.getCase(originalTokens[k])));
                    }
                    System.out.format("SUGEST\u00c3O: '%s'\n", s);
                    suggestions.add(s.toString());
                }
                mistakes.add(this.createMistake(id, suggestions.toArray(new String[0]), problem.getBegin(), problem.getEnd(), sentence.getSentence()));
            }
        }
        catch (Exception e) {
            LOGGER.fatal((Object)"Exception checking sentence with Ruta. ", (Throwable)e);
        }
        return mistakes;
    }

    private String[] createSuggestion(String error) {
        String[] array = new String[]{error};
        return array;
    }

    private synchronized void initTypeSystem(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        if (this.typeSystemInitialized) {
            return;
        }
        this.mProblemType = AnnotatorUtil.getType(typeSystem, "cogroo.ruta.Main.PROBLEM");
        this.mIDFeature = AnnotatorUtil.getRequiredFeature(this.mProblemType, "id", "uima.cas.String");
        this.mSuggestionFeature = AnnotatorUtil.getRequiredFeature(this.mProblemType, "suggestion", "uima.cas.String");
        this.typeSystemInitialized = true;
    }

    public String getIdPrefix() {
        return "uima:";
    }

    public int getPriority() {
        return 100;
    }

    private List<Token> getTokens(Sentence sentence, int begin, int end) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Span span = new Span(begin, end);
        for (Token token : sentence.getTokens()) {
            if (!span.contains(token.getSpan())) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        ComponentFactory factory = ComponentFactory.create((Locale)new Locale("pt", "BR"));
        Analyzer cogroo = factory.createPipe();
        GrammarChecker gc = new GrammarChecker(cogroo);
        CheckDocument document = new CheckDocument("segue anexos o documento solicitado.");
        gc.analyze(document);
    }
}

