/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.ruta.tools;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;
import org.cogroo.util.ResourcesUtil;

public class RuleParser {
    private RuleParser() {
    }

    private static List<Example> buildExampleArray(List<String> correctExamples, List<String> incorrectExamples) {
        ArrayList<Example> examples = new ArrayList<Example>();
        while (!correctExamples.isEmpty() && !incorrectExamples.isEmpty()) {
            String ce = correctExamples.remove(0);
            String ie = incorrectExamples.remove(0);
            Example example = new Example();
            example.setCorrect(ce);
            example.setIncorrect(ie);
            examples.add(example);
        }
        correctExamples.clear();
        incorrectExamples.clear();
        return examples;
    }

    public static Set<RuleDefinition> getRuleDefinitionList(String fileName) {
        Path path;
        try {
            path = ResourcesUtil.getResourceFile(RuleParser.class, (String)fileName).toPath();
            System.out.println(path);
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
        return RuleParser.getRuleDefinitionList(path);
    }

    public static Set<RuleDefinition> getRuleDefinitionList(Path path) {
        HashSet<RuleDefinition> rules = new HashSet<RuleDefinition>();
        try {
            HashMap<String, String> rule = new HashMap<String, String>();
            ArrayList<String> correctExamples = new ArrayList<String>();
            ArrayList<String> incorrectExamples = new ArrayList<String>();
            for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
                if ((line = line.trim()).length() == 0 && rule.containsKey("id")) {
                    List<Example> examples = RuleParser.buildExampleArray(correctExamples, incorrectExamples);
                    rules.add((RuleDefinition)new JavaRuleDefinition((String)rule.get("id"), (String)rule.get("category"), (String)rule.get("group"), (String)rule.get("description"), "RUTA: " + (String)rule.get("message"), "RUTA: " + (String)rule.get("shortMessage"), examples));
                    rule.clear();
                    continue;
                }
                String[] fields = line.split("=", 2);
                if (fields.length < 2) continue;
                fields[0] = fields[0].trim();
                fields[1] = fields[1].trim();
                if (fields[0].equals("correctExample")) {
                    correctExamples.add(fields[1]);
                    continue;
                }
                if (fields[0].equals("incorrectExample")) {
                    incorrectExamples.add(fields[1]);
                    continue;
                }
                rule.put(fields[0], fields[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rules;
    }
}

