/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.ruta.uima;

import java.util.Locale;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.ruta.uima.AnnotatorUtil;
import org.cogroo.text.Chunk;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;
import org.cogroo.text.impl.DocumentImpl;

public class CoGrOOUIMA
extends CasAnnotator_ImplBase {
    public static final String CHUNK_TYPE_PARAMETER = "opennlp.uima.ChunkType";
    public static final String CHUNK_TAG_FEATURE_PARAMETER = "opennlp.uima.ChunkTagFeature";
    private Type mSentenceType;
    private Type mTokenType;
    private Type mChunkType;
    private Feature mPosFeature;
    private Analyzer cogroo;
    private UimaContext context;
    private Logger mLogger;
    private Feature mChunkFeature;
    private Feature mLemmaFeature;
    private Feature mFeaturesFeature;
    private Feature mLexemeFeature;
    private Feature mChunkHead;
    private Type mSyntacticChunkType;
    private Feature mSyntacticChunkFeature;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the CoGrOO annotator.");
        }
        ComponentFactory factory = ComponentFactory.create((Locale)new Locale("pt", "BR"));
        this.cogroo = factory.createPipe();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mSentenceType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.Sentence");
        this.mTokenType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.Token");
        this.mPosFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "pos", "uima.cas.String");
        this.mLexemeFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "lexeme", "uima.cas.String");
        this.mLemmaFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "lemma", "uima.cas.StringArray");
        this.mFeaturesFeature = AnnotatorUtil.getRequiredFeature(this.mTokenType, "features", "uima.cas.String");
        this.mChunkType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.Chunk");
        this.mChunkFeature = AnnotatorUtil.getRequiredFeature(this.mChunkType, "chunkType", "uima.cas.String");
        this.mChunkHead = AnnotatorUtil.getRequiredFeature(this.mChunkType, "head", "opennlp.uima.Token");
        this.mSyntacticChunkType = AnnotatorUtil.getType(typeSystem, "opennlp.uima.SyntacticChunk");
        this.mSyntacticChunkFeature = AnnotatorUtil.getRequiredFeature(this.mSyntacticChunkType, "syntChunkType", "uima.cas.String");
    }

    public void process(CAS tcas) {
        String text = tcas.getDocumentText();
        DocumentImpl document = new DocumentImpl(text);
        this.cogroo.analyze((Document)document);
        for (Sentence sentence : document.getSentences()) {
            int end;
            AnnotationFS sentenceAnn = tcas.createAnnotation(this.mSentenceType, sentence.getStart(), sentence.getEnd());
            tcas.getIndexRepository().addFS((FeatureStructure)sentenceAnn);
            int sentenceOffset = sentence.getStart();
            AnnotationFS[] tokenAnnotationArr = new AnnotationFS[sentence.getTokens().size()];
            int i = 0;
            for (Token token : sentence.getTokens()) {
                tokenAnnotationArr[i] = tcas.createAnnotation(this.mTokenType, sentenceOffset + token.getStart(), sentenceOffset + token.getEnd());
                tokenAnnotationArr[i].setStringValue(this.mPosFeature, token.getPOSTag());
                tokenAnnotationArr[i].setStringValue(this.mLexemeFeature, token.getLexeme());
                StringArrayFS lemmas = tcas.createStringArrayFS(token.getLemmas().length);
                lemmas.copyFromArray(token.getLemmas(), 0, 0, token.getLemmas().length);
                tokenAnnotationArr[i].setFeatureValue(this.mLemmaFeature, (FeatureStructure)lemmas);
                tokenAnnotationArr[i].setStringValue(this.mFeaturesFeature, token.getFeatures());
                tcas.getIndexRepository().addFS((FeatureStructure)tokenAnnotationArr[i]);
                ++i;
            }
            for (Chunk chunk : sentence.getChunks()) {
                int start = ((Token)sentence.getTokens().get(chunk.getStart())).getStart() + sentenceOffset;
                end = ((Token)sentence.getTokens().get(chunk.getEnd() - 1)).getEnd() + sentenceOffset;
                AnnotationFS chunkAnn = tcas.createAnnotation(this.mChunkType, start, end);
                chunkAnn.setStringValue(this.mChunkFeature, chunk.getTag());
                if (chunk.getHeadIndex() >= 0) {
                    chunkAnn.setFeatureValue(this.mChunkHead, (FeatureStructure)tokenAnnotationArr[chunk.getHeadIndex()]);
                }
                tcas.getIndexRepository().addFS((FeatureStructure)chunkAnn);
            }
            for (SyntacticChunk sc : sentence.getSyntacticChunks()) {
                int start = ((Token)sentence.getTokens().get(sc.getStart())).getStart() + sentenceOffset;
                end = ((Token)sentence.getTokens().get(sc.getEnd() - 1)).getEnd() + sentenceOffset;
                AnnotationFS syntChunkAnn = tcas.createAnnotation(this.mSyntacticChunkType, start, end);
                syntChunkAnn.setStringValue(this.mSyntacticChunkFeature, sc.getTag());
                tcas.getIndexRepository().addFS((FeatureStructure)syntChunkAnn);
            }
        }
    }

    public void destroy() {
        this.cogroo = null;
    }
}

