/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.cogroo.addon.InternationalizedException;

public class InternationalizedRuntimeException
extends RuntimeException {
    private String mResourceBundleName;
    private String mMessageKey;
    private Object[] mArguments;
    private Throwable mCause;

    public InternationalizedRuntimeException() {
        this(null, null, null, null);
    }

    public InternationalizedRuntimeException(Throwable aCause) {
        this(null, null, null, aCause);
    }

    public InternationalizedRuntimeException(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        this(aResourceBundleName, aMessageKey, aArguments, null);
    }

    public InternationalizedRuntimeException(String aResourceBundleName, String aMessageKey, Object[] aArguments, Throwable aCause) {
        this.mCause = aCause;
        this.mResourceBundleName = aResourceBundleName;
        this.mMessageKey = aMessageKey;
        this.mArguments = aArguments;
        if (this.mResourceBundleName == null && this.mMessageKey == null) {
            if (this.mCause instanceof InternationalizedException) {
                this.mResourceBundleName = ((InternationalizedException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedException)this.mCause).getArguments();
            } else if (this.mCause instanceof InternationalizedRuntimeException) {
                this.mResourceBundleName = ((InternationalizedRuntimeException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedRuntimeException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedRuntimeException)this.mCause).getArguments();
            }
        }
    }

    public String getResourceBundleName() {
        return this.mResourceBundleName;
    }

    public String getMessageKey() {
        return this.mMessageKey;
    }

    public Object[] getArguments() {
        if (this.mArguments == null) {
            return new Object[0];
        }
        Object[] result = new Object[this.mArguments.length];
        System.arraycopy(this.mArguments, 0, result, 0, this.mArguments.length);
        return result;
    }

    public String getMessage() {
        return this.getLocalizedMessage(Locale.ENGLISH);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale aLocale) {
        if (this.getMessageKey() == null) {
            return null;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.getResourceBundleName(), aLocale);
            String message = bundle.getString(this.getMessageKey());
            if (this.getArguments().length > 0) {
                MessageFormat fmt = new MessageFormat(message);
                fmt.setLocale(aLocale);
                return fmt.format(this.getArguments());
            }
            return message;
        }
        catch (Exception e) {
            return "EXCEPTION MESSAGE LOCALIZATION FAILED: " + e.toString();
        }
    }

    public Throwable getCause() {
        return this.mCause;
    }

    public synchronized Throwable initCause(Throwable cause) {
        this.mCause = cause;
        return this;
    }
}

