/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.dialogs.reporterror;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XFixedText;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.XComponentContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.addon.AbstractAddOn;
import org.cogroo.addon.dialogs.reporterror.DialogBuilder;
import org.cogroo.addon.i18n.I18nLabelsLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportError
extends AbstractAddOn {
    protected static Logger LOGGER = LoggerImpl.getLogger(ReportError.class.getCanonicalName());
    public static final String PROTOCOL_PATH = "reportErrorDialog";
    protected XDialog dialog;
    protected XFixedText licenseView;
    protected XButton licenseButton;
    protected boolean liceneDisplayed = false;
    private String text;
    private static final String ERROR_TEXT = "error.text";
    private static final String ERROR_COMMENTS = "error.comments";

    public ReportError(XComponentContext context, String text) {
        super(context);
        this.text = text;
    }

    protected void init() {
        try {
            final DialogBuilder builder = new DialogBuilder(this.context, 102, 41, 380, 380, I18nLabelsLoader.ADDON_REPORT_ERROR);
            int left = 106;
            int pos = 10;
            int width = 300;
            int weigth = 10;
            builder.addLabel(I18nLabelsLoader.ADDON_REPORT_ERROR_TEXT + ":", "error.label.text", left, pos, width, weigth);
            builder.addTextArea(this.text, ERROR_TEXT, left, pos += weigth, width, weigth * 10);
            builder.addLabel(I18nLabelsLoader.ADDON_REPORT_ERROR_COMMENTS + ":", "error.label.comments", left, pos += weigth * 11, width, weigth);
            builder.addTextArea("", ERROR_COMMENTS, left, pos += weigth, width, weigth * 5);
            this.licenseButton = builder.addButton(I18nLabelsLoader.ADDON_REPORT_ERROR_CANCEL, "error.cancel", 35, pos += weigth * 6, width, weigth * 2);
            this.licenseButton.addActionListener(new XActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ReportError.this.setVisible(false);
                }

                public void disposing(EventObject arg0) {
                }
            });
            XButton button = builder.addButton(I18nLabelsLoader.ADDON_REPORT_ERROR_SEND, "error.send", 95, pos, 50, 15);
            button.addActionListener(new XActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    try {
                        String text = builder.getTextContent(ReportError.ERROR_TEXT);
                        String comments = builder.getTextContent(ReportError.ERROR_COMMENTS);
                        String user = "dummy";
                        URL url = new URL("http://localhost:8080/cogrooErrorReport");
                        HashMap<String, String> d = new HashMap<String, String>();
                        d.put("userName", user);
                        d.put("text", text);
                        d.put("comment", comments);
                        d.put("version", I18nLabelsLoader.ADDON_VERSION);
                        ReportError.request(false, "POST", url, d);
                        ReportError.this.setVisible(false);
                    }
                    catch (NoSuchElementException ex) {
                        Logger.getLogger(ReportError.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (ConnectException ex) {
                        Logger.getLogger(ReportError.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (WrappedTargetException ex) {
                        Logger.getLogger(ReportError.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(ReportError.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ReportError.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }

                public void disposing(EventObject arg0) {
                }
            });
            this.dialog = builder.getDialog();
            this.dialog.execute();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Uncaught exception", e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("<<< About.init()");
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.init();
        } else if (this.dialog != null) {
            this.dialog.endExecute();
        }
    }

    public String getImplementationName() {
        return this.getClass().getName();
    }

    public void dispatch(com.sun.star.util.URL url, PropertyValue[] arg1) {
        if (url.Protocol.equals("dk.abj.openoffice.addon:") && url.Path.equals(PROTOCOL_PATH)) {
            this.setVisible(true);
        }
    }

    public XDispatch queryDispatch(com.sun.star.util.URL url, String arg1, int arg2) {
        if (url.Protocol.equals("dk.abj.openoffice.addon:") && url.Path.equals(PROTOCOL_PATH)) {
            return this;
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] arg0) {
        XDispatch[] lDispatcher = new XDispatch[arg0.length];
        for (int i = 0; i < arg0.length; ++i) {
            lDispatcher[i] = this.queryDispatch(arg0[i].FeatureURL, arg0[i].FrameName, arg0[i].SearchFlags);
        }
        return lDispatcher;
    }

    private static void request(boolean quiet, String method, URL url, Map<String, String> body) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "[issuing request: " + method + " " + url + "]");
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        if (body != null) {
            connection.setDoOutput(true);
            OutputStream output = connection.getOutputStream();
            DataOutputStream out2 = new DataOutputStream(output);
            out2.writeBytes(ReportError.convert(body));
        }
        long time = System.currentTimeMillis();
        connection.connect();
        connection.disconnect();
        time = System.currentTimeMillis() - time;
        if (!quiet) {
            String header = null;
            String headerValue = null;
            int index = 0;
            while ((headerValue = connection.getHeaderField(index)) != null) {
                header = connection.getHeaderFieldKey(index);
                if (header == null) {
                    System.out.println(headerValue);
                } else {
                    System.out.println(header + ": " + headerValue);
                }
                ++index;
            }
        }
    }

    private static String convert(Map<String, String> data) {
        StringBuilder sb = new StringBuilder();
        for (String key : data.keySet()) {
            sb.append(ReportError.encode(key) + "=" + ReportError.encode(data.get(key)));
            sb.append("&");
        }
        return ((Object)sb.subSequence(0, sb.length() - 1)).toString();
    }

    private static String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ReportError.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

