/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cogroo.addon.CogrooException;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.i18n.I18nLabelsLoader;
import org.cogroo.addon.util.RestConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtil {
    protected static Logger LOG = LoggerImpl.getLogger(RestUtil.class.getCanonicalName());
    private String __userAgent = null;
    private static final Pattern imgSrc = Pattern.compile("<img\\s+id=\"gaMobileTrackingCode\"\\s+src=\"([^\"]+)\".*");
    private static final Pattern responsePattern = Pattern.compile("\\$\\{(.*?)\\|(.*?)\\}&");

    public String get(String urlRoot, String path) throws CogrooException {
        return this.execute("GET", urlRoot, path, null);
    }

    public Map<String, String> post(String urlRoot, String path, Map<String, String> data) throws CogrooException {
        return RestUtil.extractResponse(this.execute("POST", urlRoot, path, RestUtil.convert(data)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserAgent() {
        RestUtil restUtil = this;
        synchronized (restUtil) {
            if (this.__userAgent == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("CoGrOO/" + I18nLabelsLoader.ADDON_VERSION + " ");
                sb.append("(" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + ") ");
                this.__userAgent = sb.toString();
            }
        }
        return this.__userAgent;
    }

    public String execute(String method, String urlRoot, String path, String urlParameters) throws CogrooException {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            String line;
            url = RestUtil.toUrl(urlRoot, path);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setRequestProperty("User-agent", this.getUserAgent());
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            if (urlParameters != null) {
                connection.setRequestProperty("Content-Length", "" + Integer.toString(urlParameters.getBytes().length));
                DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                wr.writeBytes(urlParameters);
                wr.flush();
                wr.close();
            }
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (ConnectException e) {
            LOG.log(Level.SEVERE, "Couldn't connect to host. Is it online? URL: " + url + " method: " + method, e);
            throw new RestConnectionException("community_connect_exception", null);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Communication error. URL: " + url + " method: " + method, e);
            throw new CogrooException("community_communication_exception", new String[]{url.toString(), method});
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void getGAImg(String urlRoot, String path) throws CogrooException {
        try {
            String resp = this.get(urlRoot, path);
            if (resp != null) {
                String respImg;
                Matcher m = imgSrc.matcher(resp);
                if (m.find() && (respImg = this.get(urlRoot, m.group(1))) == null) {
                    LOG.log(Level.WARNING, "Couldn't get GA img! Get image returned null");
                }
            } else {
                LOG.log(Level.WARNING, "Couldn't get GA img!");
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Couldn't get GA img!", e);
        }
    }

    private static URL toUrl(String urlRoot, String path) throws MalformedURLException {
        return new URL(urlRoot + "/" + path);
    }

    private static String convert(Map<String, String> data) {
        StringBuilder sb = new StringBuilder();
        for (String key : data.keySet()) {
            sb.append(RestUtil.encode(key) + "=" + RestUtil.encode(data.get(key)));
            sb.append("&");
        }
        return ((Object)sb.subSequence(0, sb.length() - 1)).toString();
    }

    private static String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String prepareResponse(String key, String data) {
        return "${" + key + "|" + data + "}&";
    }

    public static Map<String, String> extractResponse(String response) {
        HashMap<String, String> data = new HashMap<String, String>();
        Matcher theMatcher = responsePattern.matcher(response);
        while (theMatcher.find()) {
            data.put(theMatcher.group(1), theMatcher.group(2));
        }
        return data;
    }
}

