/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import opennlp.tools.util.Span;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.TokenGroup;
import org.cogroo.entities.tree.Node;
import org.cogroo.entities.tree.TextModel;

public class Sentence
implements Serializable,
TokenGroup {
    private static final long serialVersionUID = -5370072688009577273L;
    protected String sentence;
    protected List<Token> tokens;
    protected List<Chunk> chunks;
    private Node root;
    private int offset;
    private Span span;
    private String doc;
    private List<SyntacticChunk> syntacticChunks = null;

    public String toPlainText() {
        return this.sentence;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sent", (Object)this.sentence).add("tks", this.tokens).add("cks", this.chunks).add("root", (Object)this.root).toString();
    }

    public String getSentence() {
        if (this.sentence != null) {
            return this.sentence;
        }
        if (this.doc != null) {
            return ((Object)this.span.getCoveredText((CharSequence)this.doc)).toString();
        }
        return null;
    }

    public String getDocumentText() {
        return this.doc;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public void setDocumentText(String document) {
        this.doc = document;
    }

    public void setSpan(Span aSpan) {
        this.span = aSpan;
    }

    public Span getSpan() {
        return this.span;
    }

    @Override
    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public List<Chunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<Chunk> chunks) {
        this.chunks = chunks;
    }

    public List<SyntacticChunk> getSyntacticChunks() {
        return this.syntacticChunks;
    }

    public void setSyntacticChunks(List<SyntacticChunk> sc) {
        this.syntacticChunks = sc;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node getRoot() {
        if (this.root != null) {
            return this.root;
        }
        Sentence sentence = this;
        synchronized (sentence) {
            if (this.root == null) {
                TextModel model = new TextModel(this);
                this.root = model.getRoot();
            }
            return this.root;
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getSyntaxTree() {
        return this.getRoot().toSyntaxTree();
    }

    public String getTree() {
        return this.getRoot().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Sentence) {
            Sentence that = (Sentence)object;
            return Objects.equal((Object)this.sentence, (Object)that.sentence) && Objects.equal(this.tokens, that.tokens) && Objects.equal(this.chunks, that.chunks) && Objects.equal((Object)this.root, (Object)that.root) && Objects.equal((Object)this.offset, (Object)that.offset);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sentence, this.tokens, this.chunks, this.root, this.offset});
    }
}

