/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.impl;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.cogroo.entities.Tag;
import org.cogroo.tools.checker.rules.model.TagMask;

public class MorphologicalTag
extends Tag
implements Cloneable {
    private static final long serialVersionUID = -2138045068621137338L;
    private TagMask.Class clazz;
    private TagMask.Gender gender;
    private TagMask.Number number;
    private TagMask.Case caze;
    private TagMask.Person person;
    private TagMask.Tense tense;
    private TagMask.Mood mood;
    private TagMask.Punctuation punctuation;

    public TagMask.Class getClazzE() {
        return this.clazz;
    }

    public void setClazz(TagMask.Class theClass) {
        this.clazz = theClass;
    }

    public TagMask.Gender getGenderE() {
        return this.gender;
    }

    public void setGender(TagMask.Gender value) {
        this.gender = value;
    }

    public TagMask.Case getCase() {
        return this.caze;
    }

    public void setCase(TagMask.Case caze) {
        this.caze = caze;
    }

    public TagMask.Mood getMood() {
        return this.mood;
    }

    public void setMood(TagMask.Mood mood) {
        this.mood = mood;
    }

    public TagMask.Tense getTense() {
        return this.tense;
    }

    public void setTense(TagMask.Tense tense) {
        this.tense = tense;
    }

    public TagMask.Punctuation getPunctuation() {
        return this.punctuation;
    }

    public void setPunctuation(TagMask.Punctuation punctuation) {
        this.punctuation = punctuation;
    }

    public TagMask.Number getNumberE() {
        return this.number;
    }

    public void setNumber(TagMask.Number value) {
        this.number = value;
    }

    public TagMask.Person getPersonE() {
        return this.person;
    }

    public void setPerson(TagMask.Person thePerson) {
        this.person = thePerson;
    }

    public boolean match(MorphologicalTag tag) {
        if (tag.getClazzE() != null ^ this.getClazzE() != null) {
            return false;
        }
        if (this.getClazzE() != null && !this.match(this.getClazzE(), tag.getClazzE())) {
            return false;
        }
        if (tag.getGenderE() != null ^ this.getGenderE() != null) {
            return false;
        }
        if (this.getGenderE() != null && this.dontMatch(tag.getGenderE())) {
            return false;
        }
        if (tag.getNumberE() != null ^ this.getNumberE() != null) {
            return false;
        }
        if (this.getNumberE() != null && this.dontMatch(tag.getNumberE())) {
            return false;
        }
        if (tag.getCase() != null ^ this.getCase() != null) {
            return false;
        }
        if (this.getCase() != null && this.getCase() != tag.getCase()) {
            return false;
        }
        if (tag.getPersonE() != null ^ this.getPersonE() != null) {
            return false;
        }
        if (this.getPersonE() != null && this.dontMatch(tag.getPersonE())) {
            return false;
        }
        if (tag.getTense() != null ^ this.getTense() != null) {
            return false;
        }
        if (this.getTense() != null && !this.match(this.getTense(), tag.getTense())) {
            return false;
        }
        if (tag.getMood() != null ^ this.getMood() != null) {
            return false;
        }
        if (this.getMood() != null && this.getMood() != tag.getMood()) {
            return false;
        }
        if (tag.getPunctuation() != null ^ this.getPunctuation() != null) {
            return false;
        }
        return this.getPunctuation() == null || this.getPunctuation() == tag.getPunctuation();
    }

    private boolean dontMatch(TagMask.Gender g) {
        return this.getGenderE() != g && this.getGenderE() != TagMask.Gender.NEUTRAL && g != TagMask.Gender.NEUTRAL;
    }

    private boolean dontMatch(TagMask.Number g) {
        return this.getNumberE() != g && this.getNumberE() != TagMask.Number.NEUTRAL && g != TagMask.Number.NEUTRAL;
    }

    private boolean dontMatch(TagMask.Person mp) {
        TagMask.Person tp = this.getPersonE();
        boolean matchFirst = !(tp != TagMask.Person.FIRST && tp != TagMask.Person.FIRST_THIRD && tp != TagMask.Person.NONE_FIRST_THIRD || mp != TagMask.Person.FIRST && mp != TagMask.Person.FIRST_THIRD && mp != TagMask.Person.NONE_FIRST_THIRD);
        boolean thirdFirst = !(tp != TagMask.Person.THIRD && tp != TagMask.Person.FIRST_THIRD && tp != TagMask.Person.NONE_FIRST_THIRD || mp != TagMask.Person.THIRD && mp != TagMask.Person.FIRST_THIRD && mp != TagMask.Person.NONE_FIRST_THIRD);
        boolean neutral = tp == TagMask.Person.NONE_FIRST_THIRD || mp == TagMask.Person.NONE_FIRST_THIRD;
        return mp != tp && !matchFirst && !thirdFirst && !neutral;
    }

    public boolean match(TagMask tagMask, boolean restricted) {
        if (tagMask.getClazz() != null && (this.getClazzE() != null || restricted) && !this.match(this.getClazzE(), tagMask.getClazz())) {
            return false;
        }
        if (tagMask.getGender() != null && (this.getGenderE() != null || restricted) && this.dontMatch(tagMask.getGender())) {
            return false;
        }
        if (tagMask.getNumber() != null && (this.getNumberE() != null || restricted) && this.dontMatch(tagMask.getNumber())) {
            return false;
        }
        if (tagMask.getCase() != null && (this.getCase() != null || restricted) && this.getCase() != tagMask.getCase()) {
            return false;
        }
        if (tagMask.getPerson() != null && (this.getPersonE() != null || restricted) && this.dontMatch(tagMask.getPerson())) {
            return false;
        }
        if (tagMask.getTense() != null && (this.getTense() != null || restricted) && !this.match(this.getTense(), tagMask.getTense())) {
            return false;
        }
        if (tagMask.getMood() != null && (this.getMood() != null || restricted) && this.getMood() != tagMask.getMood()) {
            return false;
        }
        return tagMask.getPunctuation() == null || this.getPunctuation() == null && !restricted || this.getPunctuation() == tagMask.getPunctuation();
    }

    @Override
    public boolean match(TagMask tagMask) {
        return this.match(tagMask, true);
    }

    public boolean matchExact(TagMask tagMask, boolean restricted) {
        if ((tagMask.getClazz() != null || restricted) && !this.match(this.getClazzE(), tagMask.getClazz())) {
            return false;
        }
        if ((tagMask.getGender() != null || restricted) && this.getGenderE() != tagMask.getGender()) {
            return false;
        }
        if ((tagMask.getNumber() != null || restricted) && this.getNumberE() != tagMask.getNumber()) {
            return false;
        }
        if ((tagMask.getCase() != null || restricted) && this.getCase() != tagMask.getCase()) {
            return false;
        }
        if ((tagMask.getPerson() != null || restricted) && this.getPersonE() != tagMask.getPerson()) {
            return false;
        }
        if ((tagMask.getTense() != null || restricted) && !this.match(this.getTense(), tagMask.getTense())) {
            return false;
        }
        if ((tagMask.getMood() != null || restricted) && this.getMood() != tagMask.getMood()) {
            return false;
        }
        return tagMask.getPunctuation() == null && !restricted || this.getPunctuation() == tagMask.getPunctuation();
    }

    @Override
    public String toVerboseString() {
        return this.toString();
    }

    public List<String> getAsTagList() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.getClazzE() != null) {
            res.add(this.getClazzE().toString());
        }
        if (this.getGenderE() != null) {
            res.add(this.getGenderE().toString());
        }
        if (this.getNumberE() != null) {
            res.add(this.getNumberE().toString());
        }
        if (this.getCase() != null) {
            res.add(this.getCase().toString());
        }
        if (this.getPersonE() != null) {
            res.add(this.getPersonE().toString());
        }
        if (this.getTense() != null) {
            res.add(this.getTense().toString());
        }
        if (this.getMood() != null) {
            res.add(this.getMood().toString());
        }
        if (this.getPunctuation() != null) {
            res.add(this.getPunctuation().toString());
        }
        return res;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.getClazzE() != null) {
            res.append(this.getClazzE().value() + ",");
        }
        if (this.getGenderE() != null) {
            res.append(this.getGenderE().value() + ",");
        }
        if (this.getNumberE() != null) {
            res.append(this.getNumberE().value() + ",");
        }
        if (this.getCase() != null) {
            res.append(this.getCase().value() + ",");
        }
        if (this.getPersonE() != null) {
            res.append(this.getPersonE().value() + ",");
        }
        if (this.getTense() != null) {
            res.append(this.getTense().value() + ",");
        }
        if (this.getMood() != null) {
            res.append(this.getMood().value() + ",");
        }
        if (this.getPunctuation() != null) {
            res.append(this.getPunctuation().value() + ",");
        }
        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            MorphologicalTag other = (MorphologicalTag)obj;
            return this.match(other);
        }
        return false;
    }

    public MorphologicalTag clone() {
        try {
            return (MorphologicalTag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean match(TagMask.Class a, TagMask.Class b) {
        if (Objects.equal((Object)((Object)a), (Object)((Object)b))) {
            return true;
        }
        if (a != null && a != null) {
            if (a.equals((Object)TagMask.Class.NOUN_ADJECTIVE) && (b.equals((Object)TagMask.Class.NOUN) || b.equals((Object)TagMask.Class.ADJECTIVE))) {
                return true;
            }
            if (b.equals((Object)TagMask.Class.NOUN_ADJECTIVE) && (a.equals((Object)TagMask.Class.NOUN) || a.equals((Object)TagMask.Class.ADJECTIVE))) {
                return true;
            }
        }
        return false;
    }

    private boolean match(TagMask.Tense a, TagMask.Tense b) {
        if (Objects.equal((Object)((Object)a), (Object)((Object)b))) {
            return true;
        }
        if (a != null && a != null) {
            if (a.equals((Object)TagMask.Tense.PRETERITO_PERFEITO_MAIS_QUE_PERFEITO) && (b.equals((Object)TagMask.Tense.PRETERITO_PERFEITO) || b.equals((Object)TagMask.Tense.PRETERITO_MAIS_QUE_PERFEITO))) {
                return true;
            }
            if (b.equals((Object)TagMask.Tense.PRETERITO_PERFEITO_MAIS_QUE_PERFEITO) && (a.equals((Object)TagMask.Tense.PRETERITO_PERFEITO) || a.equals((Object)TagMask.Tense.PRETERITO_MAIS_QUE_PERFEITO))) {
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.clazz == null && this.gender == null && this.number == null && this.caze == null && this.person == null && this.tense == null && this.mood == null && this.punctuation == null;
    }
}

