/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.impl;

import java.util.List;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.Token;

public class SentenceCogroo
extends Sentence {
    private static final long serialVersionUID = -7980890706769539538L;

    public SentenceCogroo(List<Token> tokens) {
        this.tokens = tokens;
    }

    public SentenceCogroo(String sentence) {
        this.sentence = sentence;
    }

    public String getAnalysisAsString() {
        if (this.tokens.size() > 0 && ((Token)this.tokens.get(0)).getMorphologicalTag() == null) {
            throw new IllegalStateException("The sentence was not analyzed yet.");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tokens.size(); ++i) {
            sb.append("[").append(((Token)this.tokens.get(i)).getSyntacticTag()).append("]");
            sb.append("[").append(((Token)this.tokens.get(i)).getChunkTag()).append("]");
            sb.append(" ").append(this.tokens.get(i)).append(" -> ");
            sb.append("{").append(((Token)this.tokens.get(i)).getPrimitive()).append("}");
            sb.append("_").append(((Token)this.tokens.get(i)).getMorphologicalTag());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toPlainText() {
        return this.sentence;
    }
}

