/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.tree;

import org.cogroo.entities.tree.TreeElement;

public class Leaf
extends TreeElement {
    private String word;
    private String features;
    private String[] lemma;
    private boolean isChunkHead;

    public void setLexeme(String lexeme) {
        this.word = lexeme;
    }

    public void setIsChunkHead(boolean value) {
        this.isChunkHead = value;
    }

    public String getLexeme() {
        return this.word;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getLevel(); ++i) {
            sb.append("=");
        }
        if (this.getSyntacticTag() != null) {
            sb.append(this.getSyntacticTag() + "(" + this.isChunkHeadStr() + this.getMorphologicalTag() + ":" + this.getFeatures() + ") ");
        }
        sb.append(this.word + "\n");
        return sb.toString();
    }

    private String isChunkHeadStr() {
        if (this.isChunkHead) {
            return "*";
        }
        return "";
    }

    public void setLemma(String[] lemma) {
        this.lemma = lemma;
    }

    public String[] getLemma() {
        return this.lemma;
    }

    @Override
    public String toSyntaxTree() {
        return "[" + this.isChunkHeadStr() + this.getMorphologicalTag() + " " + this.word + "]";
    }

    public String getFeatures() {
        return this.features;
    }

    public void setFeatures(String features) {
        this.features = features;
    }
}

