/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.entities.tree;

import java.util.List;
import opennlp.tools.util.Span;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.tree.Leaf;
import org.cogroo.entities.tree.Node;
import org.cogroo.tools.checker.rules.model.TagMask;

public class TextModel {
    private final TagMask VERB = new TagMask();
    private final TagMask NONE;
    private final TagMask SUBJ;
    private Node root;
    public static final String SPAN = "Span: ";
    public static final String SYNTACTIC_FUNCTION = "Synt.: ";
    public static final String CHUNK_FUNCTION = "Chunk.: ";
    public static final String MORPH_FUNCTION = "Morph.: ";

    public TextModel(org.cogroo.entities.Sentence sentence) {
        this.VERB.setSyntacticFunction(TagMask.SyntacticFunction.VERB);
        this.SUBJ = new TagMask();
        this.SUBJ.setSyntacticFunction(TagMask.SyntacticFunction.SUBJECT);
        this.NONE = new TagMask();
        this.NONE.setSyntacticFunction(TagMask.SyntacticFunction.NONE);
        this.root = this.toRoot(sentence);
    }

    public Node getRoot() {
        return this.root;
    }

    private Span getSpan(List<org.cogroo.entities.Token> tokens) {
        if (tokens != null && tokens.size() > 0) {
            return new Span(tokens.get(0).getSpan().getStart(), tokens.get(tokens.size() - 1).getSpan().getEnd());
        }
        return null;
    }

    private Sentence toRoot(org.cogroo.entities.Sentence sentence) {
        Sentence sent = new Sentence();
        sent.setLevel(0);
        List<SyntacticChunk> chunks = sentence.getSyntacticChunks();
        for (SyntacticChunk syntacticChunk : chunks) {
            this.addChild(syntacticChunk, (Node)sent);
        }
        return sent;
    }

    private void addChild(SyntacticChunk syntacticChunk, Node parent) {
        if (syntacticChunk.getSyntacticTag() != null && !syntacticChunk.getSyntacticTag().match(this.NONE)) {
            Chunk c = new Chunk();
            c.setLevel(parent.getLevel() + 1);
            c.setSyntacticTag(syntacticChunk.getSyntacticTag().toVerboseString());
            for (org.cogroo.entities.Chunk child : syntacticChunk.getChildChunks()) {
                this.addChild(child, (Node)c);
            }
            parent.addElement(c);
        } else {
            for (org.cogroo.entities.Chunk chunk : syntacticChunk.getChildChunks()) {
                this.addChild(chunk, parent);
            }
        }
    }

    private void addChild(org.cogroo.entities.Chunk chunk, Node parent) {
        if (chunk.getType() == null) {
            this.addChild(chunk.getTokens(), parent);
        } else {
            Chunk c = new Chunk();
            c.setLevel(parent.getLevel() + 1);
            c.setSyntacticTag(chunk.getType());
            this.addChild(chunk.getTokens(), (Node)c);
            parent.addElement(c);
        }
    }

    private void addChild(List<org.cogroo.entities.Token> tokenList, Node parent) {
        for (int i = 0; i < tokenList.size(); ++i) {
            this.addChild(tokenList.get(i), parent, this.isHead(i, tokenList.get(i)));
        }
    }

    private boolean isHead(int i, org.cogroo.entities.Token token) {
        int relativeIndex = i;
        return relativeIndex == token.getChunk().getRelativeHeadIndex();
    }

    private void addChild(org.cogroo.entities.Token token, Node parent, boolean isHead) {
        Token t = new Token();
        t.setLevel(parent.getLevel() + 1);
        t.setLexeme(token.getLexeme());
        t.setIsChunkHead(isHead);
        t.setMorphologicalTag(token.getMorphologicalTag().getClazzE().name());
        MorphologicalTag mt = token.getMorphologicalTag().clone();
        mt.setClazz(null);
        t.setFeatures(mt.toString());
        t.setLemma(token.getPrimitive());
        parent.addElement(t);
    }

    public class Token
    extends Leaf {
    }

    public class Chunk
    extends Node {
    }

    public class Sentence
    extends Node {
        @Override
        public String getSyntacticTag() {
            return "S";
        }
    }

    public class Text
    extends Node {
    }
}

