/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.gc.cmdline.grammarchecker;

import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Scanner;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.checker.CheckDocument;
import org.cogroo.gc.cmdline.grammarchecker.LanguageCountryParams;
import org.cogroo.util.TextUtils;

public class TextAnalyzerTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "analyzes a text document";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        ComponentFactory factory;
        Params params = (Params)this.validateAndParseParams(args, Params.class);
        String lang = params.getLang();
        CmdLineUtil.checkLanguageCode((String)lang);
        String country = params.getCountry();
        if (Strings.isNullOrEmpty((String)country)) {
            throw new TerminateToolException(1, "Country cannot be empty. Example country: BR");
        }
        long start = System.nanoTime();
        try {
            factory = ComponentFactory.create(new Locale(lang, country));
        }
        catch (InitializationException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not find configuration for " + lang + ". Only " + new Locale("pt", "BR") + " might be supported for now.");
        }
        Analyzer cogroo = factory.createPipe();
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter the sentence or 'q' to quit: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            CheckDocument document = new CheckDocument();
            document.setText(input);
            cogroo.analyze(document);
            System.out.println(TextUtils.nicePrint(document));
            System.out.print("Enter the sentence or 'q' to quit: ");
            input = kb.nextLine();
        }
    }

    static interface Params
    extends LanguageCountryParams {
    }
}

