/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.gc.cmdline.grammarchecker;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.analyzer.InitializationException;
import org.cogroo.checker.GrammarChecker;
import org.cogroo.gc.cmdline.grammarchecker.LanguageCountryParams;
import org.cogroo.tools.checker.rules.CogrooHtml;

public class XMLRulesReportTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "creates a HTML report for the XML rules";
    }

    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    public void run(String[] args) {
        GrammarChecker cogroo;
        ComponentFactory factory;
        Params params = (Params)this.validateAndParseParams(args, Params.class);
        String lang = params.getLang();
        CmdLineUtil.checkLanguageCode((String)lang);
        File outFile = params.getOutputFile();
        CmdLineUtil.checkOutputFile((String)"report file", (File)outFile);
        String country = params.getCountry();
        if (Strings.isNullOrEmpty((String)country)) {
            throw new TerminateToolException(1, "Country cannot be empty. Example country: BR");
        }
        try {
            factory = ComponentFactory.create(new Locale(lang, country));
        }
        catch (InitializationException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not find configuration for " + lang + ". Only " + new Locale("pt", "BR") + " might be supported for now.");
        }
        try {
            cogroo = new GrammarChecker(factory.createPipe());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Could not create pipeline!");
        }
        try {
            CogrooHtml report = new CogrooHtml(outFile, cogroo);
            report.evaluate();
            File jsFile = new File(outFile.getParentFile(), "overlib.js");
            if (!jsFile.exists()) {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/cogroo/gc/htmlreport/overlib.js");
                FileOutputStream os = new FileOutputStream(jsFile);
                ByteStreams.copy((InputStream)is, (OutputStream)os);
                Closeables.closeQuietly((Closeable)os);
                Closeables.closeQuietly((Closeable)is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TerminateToolException(1, "Failure during report build.");
        }
    }

    static interface Params
    extends LanguageCountryParams {
        @ArgumentParser.ParameterDescription(valueName="htmlFile", description="output html file.")
        public File getOutputFile();
    }
}

