/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.impl.MistakeImpl;
import org.cogroo.tools.checker.GenericChecker;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;

public abstract class AbstractGenericChecker<T>
implements GenericChecker<T> {
    protected static final Logger LOGGER = Logger.getLogger(AbstractGenericChecker.class);
    private Set<String> ignored = Collections.synchronizedSet(new HashSet());
    private Map<String, RuleDefinition> definitions = new HashMap<String, RuleDefinition>();

    protected boolean isCheckRule(String ruleId) {
        return !this.ignored.contains(ruleId);
    }

    protected static Example createExample(String incorrect, String correct) {
        Example e = new Example();
        e.setIncorrect(incorrect);
        e.setCorrect(correct);
        return e;
    }

    protected Mistake createMistake(String ruleID, String[] suggestions, int start, int end, String text) {
        RuleDefinition ruleDefinition = this.getRuleDefinition(ruleID);
        return new MistakeImpl(ruleDefinition.getId(), this.getPriority(), ruleDefinition.getMessage(), ruleDefinition.getShortMessage(), suggestions, start, end, ruleDefinition.getExamples(), text);
    }

    protected Mistake createMistake(String ruleID, String[] longMessageArgs, String[] shortMessageArgs, String[] suggestions, int start, int end, String text) {
        RuleDefinition ruleDefinition = this.getRuleDefinition(ruleID);
        return new MistakeImpl(ruleDefinition.getId(), this.getPriority(), String.format(ruleDefinition.getMessage(), longMessageArgs), String.format(ruleDefinition.getShortMessage(), shortMessageArgs), suggestions, start, end, ruleDefinition.getExamples(), text);
    }

    @Override
    public void ignore(String id) {
        this.ignored.add(id);
    }

    @Override
    public void resetIgnored() {
        this.ignored.clear();
    }

    public AbstractGenericChecker add(RuleDefinition ruleDefinition) {
        this.definitions.put(ruleDefinition.getId(), ruleDefinition);
        return this;
    }

    public RuleDefinition getRuleDefinition(String ruleID) {
        RuleDefinition ruleDefinition = this.definitions.get(ruleID);
        if (ruleDefinition == null) {
            LOGGER.fatal((Object)("Unknow rule ID: " + ruleID));
            List<Example> empty = Collections.emptyList();
            ruleDefinition = new JavaRuleDefinition("-", "-", "-", "-", "-", "-", empty);
        }
        return ruleDefinition;
    }

    @Override
    public Collection<RuleDefinition> getRulesDefinition() {
        if (this.definitions.isEmpty()) {
            LOGGER.fatal((Object)"Rules were not defined properly! Please define the rules using the add method of AbstractChecker.");
        }
        return this.definitions.values();
    }
}

