/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opennlp.tools.util.Span;
import org.apache.log4j.Logger;
import org.cogroo.entities.Chunk;
import org.cogroo.entities.Sentence;
import org.cogroo.entities.SyntacticChunk;
import org.cogroo.entities.Token;
import org.cogroo.entities.impl.ChunkCogroo;
import org.cogroo.entities.impl.ChunkTag;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.entities.impl.SyntacticTag;
import org.cogroo.entities.impl.TokenCogroo;
import org.cogroo.interpreters.FlorestaTagInterpreter;
import org.cogroo.interpreters.TagInterpreter;
import org.cogroo.tools.checker.Merger;
import org.cogroo.tools.checker.rules.dictionary.CogrooTagDictionary;
import org.cogroo.tools.checker.rules.dictionary.TagDictionary;
import org.cogroo.tools.checker.rules.model.TagMask;

public class SentenceAdapter {
    private TagDictionary td;
    private TagInterpreter ti = new FlorestaTagInterpreter();
    private static final Logger LOGGER = Logger.getLogger(SentenceAdapter.class);
    private ChunkerConverter chunkerConverter;
    private SyntacticChunkConverter syntacticChunkerConverter;

    public SentenceAdapter(TagDictionary td) {
        this.td = td;
        this.chunkerConverter = new ChunkerConverter(this.ti);
        this.syntacticChunkerConverter = new SyntacticChunkConverter(this.ti);
    }

    public Sentence asTypedSentence(org.cogroo.text.Sentence sentence, String document) {
        Sentence typedSentence = new Sentence();
        typedSentence.setDocumentText(document);
        typedSentence.setOffset(sentence.getStart());
        typedSentence.setSpan(new Span(sentence.getStart(), sentence.getEnd()));
        ArrayList<TokenCogroo> typedTokenList = new ArrayList<TokenCogroo>();
        for (org.cogroo.text.Token token : sentence.getTokens()) {
            TokenCogroo typedToken = new TokenCogroo(new Span(token.getStart(), token.getEnd()));
            ((Token)typedToken).setLexeme(token.getLexeme());
            typedToken.setMorphologicalTag(this.createMorphologicalTag(token));
            SentenceAdapter.setPrimitiveAndGeneralize(typedToken, this.td);
            typedTokenList.add(typedToken);
        }
        typedSentence.setTokens(Collections.unmodifiableList(typedTokenList));
        this.chunkerConverter.convertChunks(sentence, typedSentence);
        this.syntacticChunkerConverter.convertChunks(sentence, typedSentence);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Typed sentence: ");
            if (LOGGER.isDebugEnabled()) {
                StringBuilder trace = new StringBuilder();
                trace.append("Show tree [" + typedSentence.getSentence() + "]: \n");
                List<Token> tokens = typedSentence.getTokens();
                for (int i = 0; i < tokens.size(); ++i) {
                    trace.append("\t[" + tokens.get(i).getSyntacticTag() + "][" + tokens.get(i).getChunkTag() + "] (ck: " + tokens.get(i).getChunk().getMorphologicalTag() + ") " + tokens.get(i) + " --> {" + tokens.get(i).getPrimitive() + "}_" + tokens.get(i).getMorphologicalTag() + "\n");
                }
                trace.append("Syntactic Elements:\n");
                for (SyntacticChunk syntacticChunk : typedSentence.getSyntacticChunks()) {
                    trace.append("\t").append(syntacticChunk).append("\n");
                }
                trace.append("Chunks:\n");
                for (Chunk chunk : typedSentence.getChunks()) {
                    trace.append("\t").append(chunk).append("\n");
                }
                trace.append("\n\nAs syntactic tree: " + typedSentence.getSyntaxTree() + "\n");
                LOGGER.debug((Object)trace.toString());
            }
        }
        return typedSentence;
    }

    private MorphologicalTag createMorphologicalTag(org.cogroo.text.Token token) {
        String tag = "-".equals(token.getFeatures()) ? token.getPOSTag() : token.getPOSTag() + "=" + token.getFeatures();
        return this.ti.parseMorphologicalTag(tag);
    }

    public static void setPrimitiveAndGeneralize(Token tok, CogrooTagDictionary dict) {
        Merger.generalizePOSTags(tok.getMorphologicalTag(), dict.getTags(tok.getLexeme(), false));
        String[] primitives = dict.getPrimitive(tok.getLexeme(), tok.getMorphologicalTag(), true);
        if (primitives == null) {
            primitives = dict.getPrimitive(tok.getLexeme().toLowerCase(), tok.getMorphologicalTag(), true);
        }
        if (primitives == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Missing lemma for: " + tok));
            }
            String[] primitive = new String[]{tok.getLexeme()};
            tok.setPrimitive(primitive);
        } else {
            tok.setPrimitive(primitives);
        }
    }

    private static class ChunkerConverter {
        private final TagInterpreter corpusTagInterpreter;

        public ChunkerConverter(TagInterpreter corpusTagInterpreter) {
            this.corpusTagInterpreter = corpusTagInterpreter;
        }

        public void convertChunks(org.cogroo.text.Sentence sentence, Sentence typedSentence) {
            if (sentence.getChunks() == null) {
                this.createFakeChunks(typedSentence);
                return;
            }
            List<Token> typedTokens = typedSentence.getTokens();
            for (int i = 0; i < sentence.getTokens().size(); ++i) {
                org.cogroo.text.Token textToken = sentence.getTokens().get(i);
                Token typedToken = typedTokens.get(i);
                ChunkTag tag = this.corpusTagInterpreter.parseChunkTag(textToken.getChunkTag());
                typedToken.setChunkTag(tag);
            }
            ArrayList<Chunk> chunks = new ArrayList<Chunk>(sentence.getChunks().size());
            for (org.cogroo.text.Chunk textChunk : sentence.getChunks()) {
                int head = textChunk.getHeadIndex() != -1 ? textChunk.getHeadIndex() : textChunk.getStart();
                ChunkTag ctag = this.corpusTagInterpreter.parseChunkTag(sentence.getTokens().get(head).getChunkTag() + "*");
                if (ctag != null) {
                    typedTokens.get(head).setChunkTag(ctag);
                }
                MorphologicalTag tag = typedTokens.get(head).getMorphologicalTag().clone();
                ArrayList<Token> tokens = new ArrayList<Token>();
                for (int i = textChunk.getStart(); i < textChunk.getEnd(); ++i) {
                    tokens.add(typedTokens.get(i));
                }
                ChunkCogroo typedChunk = new ChunkCogroo(tokens, textChunk.getStart());
                typedChunk.setType(textChunk.getTag());
                for (Token token : tokens) {
                    token.setChunk(typedChunk);
                }
                ((Chunk)typedChunk).setMorphologicalTag(tag);
                chunks.add(typedChunk);
            }
            for (Token token : typedTokens) {
                if (token.getChunk() != null) continue;
                ChunkCogroo c = new ChunkCogroo(Collections.singletonList(token), 0);
                ((Chunk)c).setMorphologicalTag(token.getMorphologicalTag().clone());
                token.setChunk(c);
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Typed chunks:\n");
                for (Chunk chunk : chunks) {
                    sb.append("  ");
                    for (Token t : chunk.getTokens()) {
                        sb.append(t.getLexeme()).append(" ");
                    }
                    sb.append("\n  -- MT: " + chunk.getMorphologicalTag() + "\n");
                }
                LOGGER.debug((Object)sb.toString());
            }
            typedSentence.setChunks(chunks);
        }

        private void createFakeChunks(Sentence typedSentence) {
            int index = 0;
            ArrayList<Chunk> cl = new ArrayList<Chunk>();
            for (Token token : typedSentence.getTokens()) {
                token.setChunkTag(this.corpusTagInterpreter.parseChunkTag("O"));
                ChunkCogroo chunk = new ChunkCogroo(Collections.singletonList(token), index++);
                chunk.setMorphologicalTag(token.getMorphologicalTag().clone());
                token.setChunk(chunk);
                cl.add(chunk);
            }
            typedSentence.setChunks(cl);
        }
    }

    private static class SyntacticChunkConverter {
        private final TagInterpreter corpusTagInterpreter;

        public SyntacticChunkConverter(TagInterpreter corpusTagInterpreter) {
            this.corpusTagInterpreter = corpusTagInterpreter;
        }

        public void convertChunks(org.cogroo.text.Sentence sentence, Sentence typedSentence) {
            if (sentence.getSyntacticChunks() == null) {
                this.createFakeChunks(typedSentence);
                return;
            }
            int lastToken = 0;
            ArrayList<SyntacticChunk> typedSyntacticChunks = new ArrayList<SyntacticChunk>();
            List<Token> typedTokens = typedSentence.getTokens();
            for (org.cogroo.text.SyntacticChunk syntacticChunk : sentence.getSyntacticChunks()) {
                int start = syntacticChunk.getStart();
                int end = syntacticChunk.getEnd();
                for (int i = lastToken; i < start; ++i) {
                    typedSyntacticChunks.add(this.createNoneSyntacticChunk(typedTokens.get(i)));
                }
                lastToken = end;
                ArrayList<Chunk> typedChunks = new ArrayList<Chunk>();
                for (int i = start; i < end; ++i) {
                    Chunk tc = typedTokens.get(i).getChunk();
                    if (typedChunks.size() != 0 && ((Chunk)typedChunks.get(typedChunks.size() - 1)).equals(tc)) continue;
                    typedChunks.add(tc);
                }
                SyntacticChunk typedSyntacticChunk = new SyntacticChunk(typedChunks);
                typedSyntacticChunk.setSyntacticTag(this.corpusTagInterpreter.parseSyntacticTag(syntacticChunk.getTag()));
                for (int i = start; i < end; ++i) {
                    typedTokens.get(i).setSyntacticChunk(typedSyntacticChunk);
                }
                typedSyntacticChunks.add(typedSyntacticChunk);
            }
            for (int i = lastToken; i < typedTokens.size(); ++i) {
                typedSyntacticChunks.add(this.createNoneSyntacticChunk(typedTokens.get(i)));
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Typed syntatic chunks:\n");
                for (SyntacticChunk chunk : typedSyntacticChunks) {
                    sb.append("  ");
                    for (Token token : chunk.getTokens()) {
                        sb.append(token.getLexeme()).append(" ");
                    }
                    sb.append("\n  MT: ").append(chunk.getMorphologicalTag()).append("\n");
                }
                LOGGER.debug((Object)sb.toString());
            }
            typedSentence.setSyntacticChunks(Collections.unmodifiableList(typedSyntacticChunks));
        }

        private void createFakeChunks(Sentence typedSentence) {
            ArrayList<SyntacticChunk> sc = new ArrayList<SyntacticChunk>();
            for (Token token : typedSentence.getTokens()) {
                SyntacticChunk chunk = new SyntacticChunk(Collections.singletonList(token.getChunk()));
                chunk.setSyntacticTag(this.corpusTagInterpreter.parseSyntacticTag("O"));
                token.setSyntacticChunk(chunk);
                sc.add(chunk);
            }
            typedSentence.setSyntacticChunks(sc);
        }

        private SyntacticChunk createNoneSyntacticChunk(Token token) {
            SyntacticChunk noneTypedSyntacticChunk = new SyntacticChunk(Collections.singletonList(token.getChunk()));
            SyntacticTag st = new SyntacticTag();
            st.setSyntacticFunction(TagMask.SyntacticFunction.NONE);
            noneTypedSyntacticChunk.setSyntacticTag(st);
            token.setSyntacticChunk(noneTypedSyntacticChunk);
            return noneTypedSyntacticChunk;
        }
    }
}

