/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.applier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.cogroo.tools.checker.rules.applier.AcceptState;
import org.cogroo.tools.checker.rules.applier.RulesProvider;
import org.cogroo.tools.checker.rules.applier.RulesTree;
import org.cogroo.tools.checker.rules.applier.RulesTrees;
import org.cogroo.tools.checker.rules.applier.State;
import org.cogroo.tools.checker.rules.model.PatternElement;
import org.cogroo.tools.checker.rules.model.Rule;
import org.cogroo.tools.checker.rules.util.EqualsUtils;
import org.cogroo.tools.checker.rules.util.RuleUtils;
import org.cogroo.tools.checker.rules.util.RulesProperties;

public class RulesTreesBuilder {
    private static final Logger LOGGER = Logger.getLogger(RulesTreesBuilder.class);
    private volatile long[] activeRules;
    private final RulesProvider rulesProvider;
    private RulesTrees trees;
    private int[] currentState = new int[3];
    private int[] nextState = new int[3];

    public RulesTreesBuilder(RulesProvider rulesProvider) {
        this(rulesProvider, null);
    }

    public RulesTreesBuilder(RulesProvider rulesProvider, long[] activeRules) {
        this.rulesProvider = rulesProvider;
        this.activeRules = activeRules;
        this.trees = this.buildTrees();
    }

    private RulesTrees buildTrees() {
        long start = System.nanoTime();
        ArrayList<List<State>> rawRulesTrees = new ArrayList<List<State>>(3);
        for (int i = 0; i < 3; ++i) {
            rawRulesTrees.add(new ArrayList());
            ((List)rawRulesTrees.get(i)).add(new State(0, new PatternElement()));
            this.currentState[i] = 0;
            this.nextState[i] = 1;
        }
        for (Rule rule : this.rulesProvider.getRules().getRule()) {
            if (!this.isActive(rule)) continue;
            int i = 0;
            int treeIndex = 0;
            if (rule.getMethod() == Rule.Method.GENERAL) {
                treeIndex = 0;
            } else if (rule.getMethod() == Rule.Method.PHRASE_LOCAL) {
                treeIndex = 1;
            } else if (rule.getMethod() == Rule.Method.SUBJECT_VERB) {
                treeIndex = 2;
            }
            for (PatternElement element : rule.getPattern().getPatternElement()) {
                int reuseStateIndex = -1;
                List<State> nextStates = ((State)((List)rawRulesTrees.get(treeIndex)).get(this.currentState[treeIndex])).getNextStates();
                if (nextStates.isEmpty()) {
                    this.createState(rawRulesTrees, i, element, nextStates, rule, treeIndex);
                } else {
                    for (int j = 0; j < nextStates.size(); ++j) {
                        if (!EqualsUtils.arePatternElementEquals(nextStates.get(j).getElement(), element)) continue;
                        reuseStateIndex = nextStates.get(j).getName();
                        break;
                    }
                    if (reuseStateIndex == -1) {
                        this.createState(rawRulesTrees, i, element, nextStates, rule, treeIndex);
                    } else {
                        this.currentState[treeIndex] = reuseStateIndex;
                    }
                }
                ++i;
            }
        }
        LOGGER.info((Object)("Rules trees built in " + (System.nanoTime() - start) / 1000000L + "ms"));
        return this.buildRulesTrees(rawRulesTrees);
    }

    private boolean isActive(Rule rule) {
        if (this.activeRules == null) {
            return rule.isActive();
        }
        boolean isActive = Arrays.binarySearch(this.activeRules, rule.getId()) >= 0;
        return isActive;
    }

    private RulesTrees buildRulesTrees(List<List<State>> rawRulesTrees) {
        ArrayList<RulesTree> rulesList = new ArrayList<RulesTree>();
        for (int i = 0; i < rawRulesTrees.size(); ++i) {
            rulesList.add(new RulesTree(rawRulesTrees.get(i)));
        }
        return new RulesTrees(rulesList);
    }

    private void createState(List<List<State>> tree, int elementPosition, PatternElement element, List<State> nextStates, Rule rule, int treeIndex) {
        if (elementPosition < rule.getPattern().getPatternElement().size() - 1) {
            State newState = new State(this.nextState[treeIndex], element);
            nextStates.add(newState);
            tree.get(treeIndex).add(newState);
            this.currentState[treeIndex] = this.nextState[treeIndex];
        } else {
            AcceptState newState = new AcceptState(this.nextState[treeIndex], element, rule);
            nextStates.add(newState);
            tree.get(treeIndex).add(newState);
            this.currentState[treeIndex] = 0;
        }
        int n = treeIndex;
        this.nextState[n] = this.nextState[n] + 1;
    }

    public RulesTrees getRulesTrees() {
        return this.trees == null || RulesProperties.isRereadRules() ? this.buildTrees() : this.trees;
    }

    public void printRulesTree(State rootState) {
        List<State> nextStates = rootState.getNextStates();
        if (nextStates.isEmpty()) {
            return;
        }
        for (int i = 0; i < rootState.getNextStates().size(); ++i) {
            State currState = nextStates.get(i);
            String accept = "";
            if (currState instanceof AcceptState) {
                accept = Long.toString(((AcceptState)currState).getRule().getId());
            }
            System.out.printf("state[%4d], parent[%4d], rule[%4s], element[%s]\n", currState.getName(), rootState.getName(), accept, RuleUtils.getPatternElementAsString(currState.getElement()));
            this.printRulesTree(nextStates.get(i));
        }
    }
}

