/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo;

import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.Scanner;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.text.impl.DocumentImpl;
import org.cogroo.util.TextUtils;

public class CLI {
    public static void main(String[] args) throws FileNotFoundException {
        long start = System.nanoTime();
        if (args.length != 1) {
            System.err.println("Language is missing! usage: CLI pt_br");
            return;
        }
        ComponentFactory factory = ComponentFactory.create(new Locale("pt", "BR"));
        Analyzer pipe = factory.createPipe();
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter the sentence: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            if (input.equals("0")) {
                input = "Fomos levados \u00e0 crer que os menino s\u00e3o burro de doer. As menina chegaram.";
            }
            DocumentImpl document = new DocumentImpl();
            document.setText(input);
            pipe.analyze(document);
            System.out.println(TextUtils.nicePrint(document));
            System.out.print("Enter the sentence: ");
            input = kb.nextLine();
        }
    }
}

