/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.text.impl;

import com.google.common.base.Objects;
import java.util.List;
import opennlp.tools.util.Span;
import org.cogroo.text.Chunk;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.SyntacticChunk;
import org.cogroo.text.Token;
import org.cogroo.text.tree.Node;
import org.cogroo.text.tree.TreeUtil;

public class SentenceImpl
implements Sentence {
    private Span span;
    private List<Token> tokens;
    private List<Chunk> chunks;
    private List<SyntacticChunk> syntacticChunks;
    private Document theDocument;
    private double tokensProb;

    public SentenceImpl(int start, int end, Document theDocument) {
        this(start, end, null, theDocument);
    }

    public SentenceImpl(int start, int end, List<Token> tokens, Document theDocument) {
        this.span = new Span(start, end);
        this.tokens = tokens;
        this.theDocument = theDocument;
    }

    @Override
    public String getText() {
        return ((Object)this.span.getCoveredText(this.theDocument.getText())).toString();
    }

    @Override
    public List<Token> getTokens() {
        return this.tokens;
    }

    @Override
    public void setTokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    @Override
    public List<Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    public void setChunks(List<Chunk> chunks) {
        this.chunks = chunks;
    }

    @Override
    public List<SyntacticChunk> getSyntacticChunks() {
        return this.syntacticChunks;
    }

    @Override
    public void setSyntacticChunks(List<SyntacticChunk> syntacticChunks) {
        this.syntacticChunks = syntacticChunks;
    }

    @Override
    public Node asTree() {
        return TreeUtil.createTree(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SentenceImpl) {
            SentenceImpl that = (SentenceImpl)obj;
            return Objects.equal(this.tokens, that.tokens) && Objects.equal((Object)this.span, (Object)that.span);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("span", (Object)this.span).add("tk", this.tokens).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.span, this.tokens});
    }

    @Override
    public int getStart() {
        return this.span.getStart();
    }

    @Override
    public int getEnd() {
        return this.span.getEnd();
    }

    @Override
    public void setBoundaries(int start, int end) {
        this.span = new Span(start, end);
    }

    @Override
    public double getTokensProb() {
        return this.tokensProb;
    }

    @Override
    public void setTokensProb(double prob) {
        this.tokensProb = prob;
    }
}

