/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.chunker2;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;
import org.cogroo.cmdline.chunker2.ChunkEvaluationErrorListener;
import org.cogroo.cmdline.chunker2.ChunkerDetailedFMeasureListener;
import org.cogroo.cmdline.chunker2.ChunkerDetailedFMeasureSizeListener;
import org.cogroo.cmdline.chunker2.TrainingParams;
import org.cogroo.tools.chunker2.ChunkerCrossValidator;
import org.cogroo.tools.chunker2.ChunkerEvaluationMonitor;
import org.cogroo.tools.chunker2.ChunkerFactory;

public final class Chunker2CrossValidatorTool
extends AbstractCrossValidatorTool<ChunkSample, CVToolParams> {
    public Chunker2CrossValidatorTool() {
        super(ChunkSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the chunker";
    }

    @Override
    public void run(String format, String[] args) {
        ChunkerCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        LinkedList<ChunkerEvaluationMonitor> listeners = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener detailedFMeasureListener = null;
        ChunkerDetailedFMeasureSizeListener detailedFMeasureForSizeListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new ChunkEvaluationErrorListener());
        }
        if (((CVToolParams)this.params).getDetailedF().booleanValue()) {
            detailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            listeners.add(detailedFMeasureListener);
            detailedFMeasureForSizeListener = new ChunkerDetailedFMeasureSizeListener();
            listeners.add(detailedFMeasureForSizeListener);
        }
        try {
            ChunkerFactory chunkerFactory = ChunkerFactory.create(((CVToolParams)this.params).getFactory());
            validator = new ChunkerCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, chunkerFactory, listeners.toArray(new ChunkerEvaluationMonitor[listeners.size()]));
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        if (detailedFMeasureListener == null) {
            FMeasure result = validator.getFMeasure();
            System.out.println(result.toString());
        } else {
            System.out.println(detailedFMeasureListener.toString());
            System.out.println();
            System.out.println(detailedFMeasureForSizeListener.toString());
        }
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

