/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.chunker2;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.cmdline.chunker2.ChunkerModelLoader;
import org.cogroo.tools.chunker2.ChunkerME;
import org.cogroo.tools.chunker2.ChunkerModel;

public class Chunker2Tool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable chunker";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(new File(args[0]));
            ChunkerME chunker = new ChunkerME(model, 10);
            PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            try {
                String line;
                while ((line = (String)lineStream.read()) != null) {
                    POSSample posSample;
                    try {
                        posSample = POSSample.parse(line);
                    }
                    catch (InvalidFormatException e) {
                        System.err.println("Invalid format:");
                        System.err.println(line);
                        continue;
                    }
                    String[] chunks = chunker.chunk(posSample.getSentence(), posSample.getTags());
                    System.out.println(new ChunkSample(posSample.getSentence(), posSample.getTags(), chunks).nicePrint());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

