/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.chunker2;

import java.io.File;
import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.util.model.ModelUtil;
import org.cogroo.cmdline.chunker2.TrainingParams;
import org.cogroo.tools.chunker2.ChunkerFactory;
import org.cogroo.tools.chunker2.ChunkerME;
import org.cogroo.tools.chunker2.ChunkerModel;

public class Chunker2TrainerTool
extends AbstractTrainerTool<ChunkSample, TrainerToolParams> {
    public Chunker2TrainerTool() {
        super(ChunkSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable chunker";
    }

    @Override
    public void run(String format, String[] args) {
        ChunkerModel model;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File modelOutFile = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("sentence detector model", modelOutFile);
        try {
            ChunkerFactory chunkerFactory = ChunkerFactory.create(((TrainerToolParams)this.params).getFactory());
            model = ChunkerME.train(((TrainerToolParams)this.params).getLang(), this.sampleStream, this.mlParams, chunkerFactory);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("chunker", modelOutFile, model);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

