/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.cmdline.featurizer;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.postag.ExtendedPOSDictionary;
import opennlp.tools.util.model.ModelUtil;
import org.cogroo.cmdline.featurizer.FeaturizerEvaluationErrorListener;
import org.cogroo.cmdline.featurizer.TrainingParams;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerCrossValidator;
import org.cogroo.tools.featurizer.FeaturizerEvaluationMonitor;

public final class FeaturizerCrossValidatorTool
extends AbstractCrossValidatorTool<FeatureSample, CVToolParams> {
    public FeaturizerCrossValidatorTool() {
        super(FeatureSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the featurizer";
    }

    @Override
    public void run(String format, String[] args) {
        FeaturizerCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        LinkedList<FeaturizerEvaluationErrorListener> listeners = new LinkedList<FeaturizerEvaluationErrorListener>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new FeaturizerEvaluationErrorListener());
        }
        try {
            ExtendedPOSDictionary tagdict = null;
            if (((CVToolParams)this.params).getDict() != null) {
                long start = System.nanoTime();
                tagdict = ExtendedPOSDictionary.create(new FileInputStream(((CVToolParams)this.params).getDict()));
                System.out.println("ExtendedPOSDictionary loaded in " + (System.nanoTime() - start) / 1000000L + "ms");
            }
            String factoryName = ((CVToolParams)this.params).getFactory();
            validator = new FeaturizerCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, tagdict, ((CVToolParams)this.params).getCGFlags(), factoryName, listeners.toArray(new FeaturizerEvaluationMonitor[listeners.size()]));
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage());
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.out.println();
        System.out.println("Accuracy: " + validator.getWordAccuracy());
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    DetailedFMeasureEvaluatorParams {
    }
}

