/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.dictionary.impl;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import opennlp.tools.postag.TagDictionary;
import org.apache.log4j.Logger;
import org.cogroo.dictionary.LemmaDictionary;
import org.cogroo.util.PairWordPOSTag;

public class FSADictionary
implements TagDictionary,
LemmaDictionary,
Iterable<String> {
    protected static final Logger LOGGER = Logger.getLogger(FSADictionary.class);
    private DictionaryLookup dictLookup;
    private LoadingCache<String, Optional<String[]>> tagCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<String[]>>(){

        public Optional<String[]> load(String key) {
            String[] val = FSADictionary.this.tagLookup(key);
            return Optional.fromNullable((Object)val);
        }
    });
    private LoadingCache<String, List<PairWordPOSTag>> lemmaTagCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<PairWordPOSTag>>(){

        public List<PairWordPOSTag> load(String key) {
            return FSADictionary.this.lemmaTagLookup(key);
        }
    });

    private FSADictionary(DictionaryLookup dictLookup) {
        this.dictLookup = dictLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] tagLookup(String word) {
        DictionaryLookup dictionaryLookup = this.dictLookup;
        synchronized (dictionaryLookup) {
            List data = this.dictLookup.lookup((CharSequence)word);
            if (data.size() > 0) {
                ArrayList<String> tags = new ArrayList<String>(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    if (!this.isValid((WordData)data.get(i))) continue;
                    tags.add(((Object)((WordData)data.get(i)).getTag()).toString());
                }
                if (tags.size() > 0) {
                    return tags.toArray(new String[tags.size()]);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PairWordPOSTag> lemmaTagLookup(String word) {
        DictionaryLookup dictionaryLookup = this.dictLookup;
        synchronized (dictionaryLookup) {
            List data = this.dictLookup.lookup((CharSequence)word);
            if (data.size() > 0) {
                ArrayList<PairWordPOSTag> list = new ArrayList<PairWordPOSTag>(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    WordData wd = (WordData)data.get(i);
                    if (!this.isValid(wd)) continue;
                    list.add(new PairWordPOSTag(((Object)wd.getStem()).toString(), ((Object)wd.getTag()).toString()));
                }
                return Collections.unmodifiableList(list);
            }
        }
        return Collections.emptyList();
    }

    private boolean isValid(WordData wd) {
        if (wd.getStem() == null) {
            LOGGER.error((Object)("Got invalid entry from FSA dictionary: " + wd));
            return false;
        }
        return true;
    }

    @Override
    public String[] getTags(String word) {
        try {
            return (String[])((Optional)this.tagCache.get((Object)word)).orNull();
        }
        catch (ExecutionException e) {
            LOGGER.info((Object)("Getting tags for word generated an exception: " + word), (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] getLemmas(String word, String tag) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            List pairs = (List)this.lemmaTagCache.get((Object)word);
            for (PairWordPOSTag pairWordPOSTag : pairs) {
                boolean match = false;
                if (pairWordPOSTag.getPosTag().equals(tag)) {
                    match = true;
                } else if ("n-adj".equals(pairWordPOSTag.getPosTag())) {
                    if ("n".equals(tag) || "adj".equals(tag)) {
                        match = true;
                    }
                } else if ("n-adj".equals(tag) && ("n".equals(pairWordPOSTag.getPosTag()) || "adj".equals(pairWordPOSTag.getPosTag()))) {
                    match = true;
                }
                if (!match) continue;
                output.add(pairWordPOSTag.getWord());
            }
        }
        catch (ExecutionException e) {
            LOGGER.info((Object)("Getting tags for word generated an exception: " + word), (Throwable)e);
            return null;
        }
        return output.toArray(new String[output.size()]);
    }

    public List<PairWordPOSTag> getTagsAndLemms(String aWord) {
        try {
            return (List)this.lemmaTagCache.get((Object)aWord);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TagDictionary create(String path) throws IllegalArgumentException, IOException {
        FileInputStream fsaData = new FileInputStream(path);
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName((String)path));
        return FSADictionary.create(fsaData, featuresData);
    }

    public static byte[] getFSADictionaryInfo(String path) throws IOException {
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName((String)path));
        return ByteStreams.toByteArray((InputStream)featuresData);
    }

    public static byte[] getFSADictionaryData(String path) throws IOException {
        FileInputStream featuresData = new FileInputStream(path);
        return ByteStreams.toByteArray((InputStream)featuresData);
    }

    public static FSADictionary create(InputStream fsaData, InputStream featuresData) throws IllegalArgumentException, IOException {
        DictionaryLookup dictLookup = new DictionaryLookup(Dictionary.readAndClose((InputStream)fsaData, (InputStream)featuresData));
        return new FSADictionary(dictLookup);
    }

    public static TagDictionary create(byte[] dictData, byte[] dictInfo) throws IllegalArgumentException, IOException {
        return FSADictionary.create(new ByteArrayInputStream(dictData), new ByteArrayInputStream(dictInfo));
    }

    public static FSADictionary createFromResources(String path) throws IllegalArgumentException, IOException {
        InputStream dic = FSADictionary.class.getResourceAsStream(path);
        InputStream info = FSADictionary.class.getResourceAsStream(Dictionary.getExpectedFeaturesName((String)path));
        FSADictionary fsa = FSADictionary.create(dic, info);
        dic.close();
        info.close();
        return fsa;
    }

    @Override
    public Iterator<String> iterator() {
        return new IteratorWrapper(this.dictLookup.iterator());
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        long start = System.nanoTime();
        String path = "/fsa_dictionaries/pos/pt_br_jspell_corpus";
        InputStream dict = FSADictionary.class.getResourceAsStream(path + ".dict");
        InputStream info = FSADictionary.class.getResourceAsStream(path + ".info");
        FSADictionary td = FSADictionary.create(dict, info);
        System.out.println("Loading time [" + (System.nanoTime() - start) / 1000000L + "ms]");
        Scanner kb = new Scanner(System.in);
        System.out.print("Enter a query: ");
        String input = kb.nextLine();
        while (!input.equals("q")) {
            if (input.equals("0")) {
                input = "c\u00e3o";
            }
            List<PairWordPOSTag> pair = td.getTagsAndLemms(input);
            for (PairWordPOSTag pairWordPOSTag : pair) {
                System.out.println(pairWordPOSTag.getPosTag() + " : " + pairWordPOSTag.getWord());
            }
            System.out.print("Enter a query: ");
            input = kb.nextLine();
        }
    }

    private static class IteratorWrapper
    implements Iterator<String> {
        private final Iterator<WordData> innerIterator;

        public IteratorWrapper(Iterator<WordData> iterator) {
            this.innerIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public String next() {
            WordData wd = this.innerIterator.next();
            if (wd != null) {
                return ((Object)wd.getWord()).toString();
            }
            return null;
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }
    }
}

