/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.dictionary.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import org.cogroo.util.PairWordPOSTag;

public class FSASynthDictionary {
    private DictionaryLookup dictLookup;

    public FSASynthDictionary(DictionaryLookup dictLookup) {
        this.dictLookup = dictLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PairWordPOSTag> synthesize(String lemma) {
        ArrayList<PairWordPOSTag> result = new ArrayList<PairWordPOSTag>();
        DictionaryLookup dictionaryLookup = this.dictLookup;
        synchronized (dictionaryLookup) {
            List data = this.dictLookup.lookup((CharSequence)lemma);
            for (WordData wordData : data) {
                result.add(new PairWordPOSTag(((Object)wordData.getStem()).toString(), ((Object)wordData.getTag()).toString()));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static FSASynthDictionary create(String path) throws IllegalArgumentException, IOException {
        FileInputStream fsaData = new FileInputStream(path);
        FileInputStream featuresData = new FileInputStream(Dictionary.getExpectedFeaturesName((String)path));
        return FSASynthDictionary.create(fsaData, featuresData);
    }

    public static FSASynthDictionary createFromResources(String path) throws IllegalArgumentException, IOException {
        InputStream dic = FSASynthDictionary.class.getResourceAsStream(path);
        InputStream info = FSASynthDictionary.class.getResourceAsStream(Dictionary.getExpectedFeaturesName((String)path));
        FSASynthDictionary fsa = FSASynthDictionary.create(dic, info);
        dic.close();
        info.close();
        return fsa;
    }

    public static FSASynthDictionary create(InputStream fsaData, InputStream featuresData) throws IllegalArgumentException, IOException {
        DictionaryLookup dictLookup = new DictionaryLookup(Dictionary.readAndClose((InputStream)fsaData, (InputStream)featuresData));
        return new FSASynthDictionary(dictLookup);
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        String dic = "fsa_dictionaries/pos/pt_br_jspell_synth.dict";
        FSASynthDictionary td = FSASynthDictionary.create(dic);
        List<PairWordPOSTag> x = td.synthesize("\u00e1rvore");
        System.out.println(Arrays.toString(x.toArray()));
    }
}

