/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.formats.ad;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.util.ObjectStream;
import org.cogroo.formats.ad.ADChunk2SampleStream;

public class ADChunkBasedHeadFinderSampleStream
extends ADChunk2SampleStream {
    List<String> newTags = null;
    List<String> headTags = null;

    @Override
    public ChunkSample read() throws IOException {
        ADSentenceStream.Sentence paragraph;
        while ((paragraph = (ADSentenceStream.Sentence)this.adSentenceStream.read()) != null) {
            ADSentenceStream.SentenceParser.Node root = paragraph.getRoot();
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> target = new ArrayList<String>();
            this.newTags = new ArrayList<String>();
            this.headTags = new ArrayList<String>();
            this.processRoot(root, sentence, tags, target);
            if (sentence.size() <= 0) continue;
            return new ChunkSample(sentence, this.newTags, this.headTags);
        }
        return null;
    }

    public ADChunkBasedHeadFinderSampleStream(InputStream in, String charsetName) {
        super(in, charsetName);
    }

    public ADChunkBasedHeadFinderSampleStream(ObjectStream<String> lineStream) {
        super(lineStream);
    }

    @Override
    protected void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, boolean isIntermediate, String phraseTag, List<String> sentence, List<String> tags, List<String> target) {
        String prev;
        super.processLeaf(leaf, isIntermediate, phraseTag, sentence, tags, target);
        int i = target.size() - 1;
        if (i > 0 && (target.get(i).startsWith("B-") || "O".equals(target.get(i))) && (prev = target.get(i - 1).substring(target.get(i - 1).indexOf(124) + 1)).startsWith("B-") && !this.headTags.get(i - 1).equals("B-H")) {
            this.headTags.set(i - 1, "B-H");
        }
        this.newTags.add(tags.get(i) + "|" + target.get(i));
        if (("H".equals(leaf.getSyntacticTag()) || "MV".equals(leaf.getSyntacticTag())) && !"O".equals(phraseTag) && this.isFirstHead(target, this.headTags)) {
            this.headTags.add("B-H");
        } else {
            this.headTags.add("O");
        }
    }

    private boolean isFirstHead(List<String> target, List<String> heads) {
        if (target.get(target.size() - 1).startsWith("B-")) {
            return true;
        }
        for (int i = target.size() - 2; i >= 0; --i) {
            if (target.get(i).startsWith("I-")) {
                if (!heads.get(i).equals("B-H")) continue;
                return false;
            }
            if (!target.get(i).startsWith("B-")) continue;
            return !heads.get(i).equals("B-H");
        }
        return true;
    }
}

