/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.formats.ad;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.Set;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.formats.ad.ADContractionNameSampleStream;

public class ADContractionNameSampleStreamFactory
extends LanguageSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "adcon", new ADContractionNameSampleStreamFactory(Parameters.class));
    }

    protected <P> ADContractionNameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        this.language = params.getLang();
        Set<String> tagSet = null;
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(params.getData());
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), params.getEncoding());
        return new ADContractionNameSampleStream(lineStream, tagSet);
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();
    }
}

