/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.formats.ad;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.cogroo.formats.ad.ADFeaturizerSampleStream;
import org.cogroo.tools.featurizer.FeatureSample;

public class ADFeatureSampleStreamFactory
extends LanguageSampleStreamFactory<FeatureSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(FeatureSample.class, "ad", new ADFeatureSampleStreamFactory(Parameters.class));
    }

    protected <P> ADFeatureSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<FeatureSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        this.language = params.getLang();
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(params.getData());
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), params.getEncoding());
        ADFeaturizerSampleStream sentenceStream = new ADFeaturizerSampleStream(lineStream, params.getExpandME());
        return sentenceStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="start", description="index of first sentence")
        @ArgumentParser.OptionalParameter
        public Integer getStart();

        @ArgumentParser.ParameterDescription(valueName="end", description="index of last sentence")
        @ArgumentParser.OptionalParameter
        public Integer getEnd();

        @ArgumentParser.ParameterDescription(valueName="expandME", description="expand multiword expressions.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getExpandME();
    }
}

