/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.chunker2;

import java.io.IOException;
import opennlp.model.AbstractEventStream;
import opennlp.model.Event;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.util.ObjectStream;
import org.cogroo.tools.chunker2.ChunkerContextGenerator;
import org.cogroo.tools.featurizer.WordTag;

public class ChunkerEventStream
extends AbstractEventStream {
    private ChunkerContextGenerator cg;
    private ObjectStream<ChunkSample> data;
    private Event[] events;
    private int ei;

    public ChunkerEventStream(ObjectStream<ChunkSample> d, ChunkerContextGenerator cg) {
        this.cg = cg;
        this.data = d;
        this.ei = 0;
        this.addNewEvents();
    }

    @Override
    public Event next() {
        this.hasNext();
        return this.events[this.ei++];
    }

    @Override
    public boolean hasNext() {
        if (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.ei < this.events.length;
    }

    private void addNewEvents() {
        ChunkSample sample;
        try {
            sample = this.data.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (sample != null) {
            this.events = new Event[sample.getSentence().length];
            WordTag[] seqArray = WordTag.create(sample);
            String[] predsArray = sample.getPreds();
            int el = this.events.length;
            for (int ei = 0; ei < el; ++ei) {
                this.events[ei] = new Event(predsArray[ei], this.cg.getContext(ei, seqArray, predsArray));
            }
        } else {
            this.events = new Event[0];
        }
    }
}

