/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.chunker2;

import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.ext.ExtensionLoader;
import org.cogroo.tools.chunker2.ChunkerContextGenerator;
import org.cogroo.tools.chunker2.DefaultChunkerContextGenerator;
import org.cogroo.tools.chunker2.DefaultChunkerSequenceValidator;
import org.cogroo.tools.featurizer.WordTag;

public class ChunkerFactory
extends BaseToolFactory {
    public static ChunkerFactory create(String subclassName) throws InvalidFormatException {
        if (subclassName == null) {
            return new ChunkerFactory();
        }
        try {
            ChunkerFactory theFactory = ExtensionLoader.instantiateExtension(ChunkerFactory.class, subclassName);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceValidator<WordTag> getSequenceValidator() {
        return new DefaultChunkerSequenceValidator();
    }

    public ChunkerContextGenerator getContextGenerator() {
        return new DefaultChunkerContextGenerator();
    }
}

