/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.chunker2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import org.cogroo.tools.chunker2.ChunkerFactory;

public class ChunkerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "ChunkerME2";
    public static final String CHUNKER_MODEL_ENTRY_NAME = "chunker2.model";

    public ChunkerModel(String languageCode, AbstractModel featurizerModel, Map<String, String> manifestInfoEntries, ChunkerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, factory);
        if (featurizerModel == null) {
            throw new IllegalArgumentException("The chunkerModel param must not be null!");
        }
        this.artifactMap.put(CHUNKER_MODEL_ENTRY_NAME, featurizerModel);
        this.checkArtifactMap();
    }

    public ChunkerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return ChunkerFactory.class;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Chunker model is incomplete!");
        }
    }

    public ChunkerFactory getFactory() {
        return (ChunkerFactory)this.toolFactory;
    }

    public AbstractModel getChunkerModel() {
        return (AbstractModel)this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME);
    }
}

