/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import opennlp.tools.util.featuregen.StringPattern;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import org.cogroo.tools.featurizer.FeaturizerContextGenerator;
import org.cogroo.tools.featurizer.WordTag;

public class DefaultFeaturizerContextGenerator
implements FeaturizerContextGenerator {
    protected final String SE = "*SE*";
    protected final String SB = "*SB*";
    private static final int PREFIX_LENGTH = 4;
    private static final int SUFFIX_LENGTH = 4;
    private TokenClassFeatureGenerator tokenClassFeatureGenerator = new TokenClassFeatureGenerator();
    private NumberFormat nf = NumberFormat.getInstance(new Locale("pt"));
    private boolean isWiderContext;
    private boolean isSuffixFeats;
    private boolean isHiphenedFeats;
    private boolean isNumberFeats;
    private boolean isClassFeatures;
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("[_-]");

    public DefaultFeaturizerContextGenerator(String flags) {
        this.isWiderContext = flags.contains("w");
        this.isSuffixFeats = flags.contains("s");
        this.isHiphenedFeats = flags.contains("h");
        this.isNumberFeats = flags.contains("n");
        this.isClassFeatures = flags.contains("c");
    }

    protected static String[] getPrefixes(String lex) {
        String[] prefs = new String[4];
        int ll = 4;
        for (int li = 0; li < ll; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }

    protected static String[] getSuffixes(String lex) {
        String[] suffs = new String[4];
        int ll = 4;
        for (int li = 0; li < ll; ++li) {
            suffs[li] = lex.substring(Math.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    public String[] getContext(int index, WordTag[] sequence, String[] priorDecisions, Object[] additionalContext) {
        String[] w = new String[sequence.length];
        String[] t = new String[sequence.length];
        WordTag.extract(sequence, w, t);
        return this.getContext(index, w, t, priorDecisions);
    }

    @Override
    public String[] getContext(int i, String[] toks, String[] tags, String[] preds) {
        ArrayList<String> e = new ArrayList<String>();
        if (this.isWiderContext) {
            this.createWindowFeats(i, toks, tags, preds, e);
        } else {
            this.create3WindowFeats(i, toks, tags, preds, e);
        }
        if (i > 0) {
            this.wrappWindowFeatures("prev_", i - 1, toks, tags, preds, e);
        }
        this.wrappWindowFeatures("", i, toks, tags, preds, e);
        if (i < toks.length - 1) {
            this.wrappWindowFeatures("nxt_", i + 1, toks, tags, preds, e);
        }
        String[] context = e.toArray(new String[e.size()]);
        return context;
    }

    private void wrappWindowFeatures(String prefix, int i, String[] toks, String[] tags, String[] preds, List<String> e) {
        String lex = toks[i];
        ArrayList<String> features = new ArrayList<String>();
        if (this.isClassFeatures) {
            this.tokenClassFeatureGenerator.createFeatures(features, toks, i, preds);
        }
        if (this.isNumberFeats) {
            this.createNumberFeats(i, toks, features);
        }
        boolean suffixesCollected = false;
        if (this.isHiphenedFeats && lex.length() >= 3) {
            if (lex.contains("_")) {
                this.createGroupSuffixex("us_", lex, features);
                suffixesCollected = true;
            }
            if (lex.contains("-")) {
                this.createGroupSuffixex("hf_", lex, features);
                suffixesCollected = true;
            }
        }
        if (!suffixesCollected && this.isSuffixFeats) {
            this.createSuffixFeats(i, toks, tags, preds, features);
        }
        for (String f : features) {
            e.add(prefix + f);
        }
    }

    private void createGroupSuffixex(String pre, String lex, List<String> e) {
        String[] parts = UNDERLINE_PATTERN.split(lex);
        if (parts.length < 2) {
            return;
        }
        for (int i = 0; i < parts.length; ++i) {
            String[] suffixes;
            e.add(pre + "up_" + i + "=" + parts[i]);
            String prefix = pre + "prsf_" + i + "=";
            for (String suf : suffixes = DefaultFeaturizerContextGenerator.getSuffixes(parts[i])) {
                e.add(prefix + suf);
            }
        }
    }

    private void createNumberFeats(int i, String[] toks, List<String> e) {
        String lex = toks[i];
        StringPattern sp = StringPattern.recognize(lex);
        if (sp.containsDigit() && !sp.containsLetters()) {
            String num = lex;
            try {
                Number number = this.nf.parse(num);
                if (number != null) {
                    Double value = Math.abs(number.doubleValue());
                    if (value >= 2.0) {
                        e.add("num=h2");
                    } else if (value >= 1.0) {
                        e.add("num=h1");
                    } else if (value > 0.0) {
                        e.add("num=h0");
                    } else {
                        e.add("num=zero");
                    }
                } else {
                    e.add("numNull");
                }
            }
            catch (ParseException e1) {
                e.add("notNum");
            }
        }
    }

    private void createSuffixFeats(int i, String[] toks, String[] tags, String[] preds, List<String> e) {
        String lex = toks[i];
        String[] suffs = DefaultFeaturizerContextGenerator.getSuffixes(lex);
        for (int j = 0; j < suffs.length; ++j) {
            e.add("suf=" + suffs[j]);
        }
        String[] prefs = DefaultFeaturizerContextGenerator.getPrefixes(lex);
        for (int j = 0; j < prefs.length; ++j) {
            e.add("pre=" + prefs[j]);
        }
        if (lex.indexOf(45) != -1) {
            e.add("h");
        }
    }

    private void createWindowFeats(int i, String[] toks, String[] tags, String[] preds, List<String> feats) {
        String w2 = null;
        String w1 = null;
        String w0 = null;
        String w_1 = null;
        String w_2 = null;
        String t2 = null;
        String t1 = null;
        String t0 = null;
        String t_1 = null;
        String t_2 = null;
        String p_2 = null;
        String p_1 = null;
        if (i < 2) {
            w_2 = "w_2=bos";
            t_2 = "t_2=bos";
            p_2 = "p_2=bos";
        } else {
            w_2 = "w_2=" + toks[i - 2];
            t_2 = "t_2=" + tags[i - 2];
            p_2 = "p_2" + preds[i - 2];
        }
        if (i < 1) {
            w_1 = "w_1=bos";
            t_1 = "t_1=bos";
            p_1 = "p_1=bos";
        } else {
            w_1 = "w_1=" + toks[i - 1];
            t_1 = "t_1=" + tags[i - 1];
            p_1 = "p_1=" + preds[i - 1];
        }
        w0 = "w0=" + toks[i];
        t0 = "t0=" + tags[i];
        if (i + 1 >= toks.length) {
            w1 = "w1=eos";
            t1 = "t1=eos";
        } else {
            w1 = "w1=" + toks[i + 1];
            t1 = "t1=" + tags[i + 1];
        }
        if (i + 2 >= toks.length) {
            w2 = "w2=eos";
            t2 = "t2=eos";
        } else {
            w2 = "w2=" + toks[i + 2];
            t2 = "t2=" + tags[i + 2];
        }
        String[] features = new String[]{w_2, w_1, w0, w1, w2, w_1 + w0, w0 + w1, t_2, t_1, t0, t1, t2, t_2 + t_1, t_1 + t0, t0 + t1, t1 + t2, t_2 + t_1 + t0, t_1 + t0 + t1, t0 + t1 + t2, p_2, p_1, p_2 + p_1, p_1 + t_2, p_1 + t_1, p_1 + t0, p_1 + t1, p_1 + t2, p_1 + t_2 + t_1, p_1 + t_1 + t0, p_1 + t0 + t1, p_1 + t1 + t2, p_1 + t_2 + t_1 + t0, p_1 + t_1 + t0 + t1, p_1 + t0 + t1 + t2, p_1 + w_2, p_1 + w_1, p_1 + w0, p_1 + w1, p_1 + w2, p_1 + w_1 + w0, p_1 + w0 + w1};
        feats.addAll(Arrays.asList(features));
    }

    private void create3WindowFeats(int i, String[] toks, String[] tags, String[] preds, List<String> feats) {
        String w_1;
        String w1 = null;
        String w0 = null;
        String t1 = null;
        String t0 = null;
        String t_1 = null;
        String p_2 = null;
        String p_1 = null;
        p_2 = i < 2 ? "p_2=bos" : "p_2" + preds[i - 2];
        if (i < 1) {
            w_1 = "w_1=bos";
            t_1 = "t_1=bos";
            p_1 = "p_1=bos";
        } else {
            w_1 = "w_1=" + toks[i - 1];
            t_1 = "t_1=" + tags[i - 1];
            p_1 = "p_1=" + preds[i - 1];
        }
        w0 = "w0=" + toks[i];
        t0 = "t0=" + tags[i];
        if (i + 1 >= toks.length) {
            w1 = "w1=eos";
            t1 = "t1=eos";
        } else {
            w1 = "w1=" + toks[i + 1];
            t1 = "t1=" + tags[i + 1];
        }
        String[] features = new String[]{w_1, w0, w1, w_1 + w0, w0 + w1, t_1, t0, t1, t_1 + t0, t0 + t1, t_1 + t0 + t1, p_2, p_1, p_2 + p_1, p_1 + t_1, p_1 + t0, p_1 + t1, p_1 + t_1 + t0, p_1 + t0 + t1, p_1 + t_1 + t0 + t1, p_1 + w_1, p_1 + w0, p_1 + w1, p_1 + w_1 + w0, p_1 + w0 + w1};
        feats.addAll(Arrays.asList(features));
    }
}

