/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FeatureSample {
    private final List<String> sentence;
    private final List<String> tags;
    private final List<String> feats;
    private final List<String> lemma;

    public FeatureSample(String[] sentence, String[] lemma, String[] tags, String[] feats) {
        FeatureSample.validateArguments(sentence.length, lemma.length, tags.length, feats.length);
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(sentence)));
        this.lemma = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(lemma)));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(tags)));
        this.feats = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(feats)));
    }

    public FeatureSample(List<String> sentence, List<String> lemma, List<String> tags, List<String> feats) {
        FeatureSample.validateArguments(sentence.size(), lemma.size(), tags.size(), feats.size());
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(sentence));
        this.lemma = Collections.unmodifiableList(new ArrayList<String>(lemma));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
        this.feats = Collections.unmodifiableList(new ArrayList<String>(feats));
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getLemmas() {
        return this.lemma.toArray(new String[this.lemma.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[] getFeatures() {
        return this.feats.toArray(new String[this.feats.size()]);
    }

    private static void validateArguments(int sentenceSize, int lemmaSize, int tagsSize, int featsSize) throws IllegalArgumentException {
        if (sentenceSize != tagsSize || tagsSize != featsSize || lemmaSize != tagsSize) {
            throw new IllegalArgumentException("All arrays must have the same length!");
        }
    }

    public String toString() {
        StringBuilder featsString = new StringBuilder();
        for (int ci = 0; ci < this.feats.size(); ++ci) {
            featsString.append(this.sentence.get(ci)).append(" [").append(this.lemma.get(ci)).append("] ").append(this.tags.get(ci)).append(" ").append(this.feats.get(ci)).append("\n");
        }
        return featsString.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FeatureSample) {
            FeatureSample a = (FeatureSample)obj;
            return Arrays.equals(this.getSentence(), a.getSentence()) && Arrays.equals(this.getTags(), a.getTags()) && Arrays.equals(this.getLemmas(), a.getLemmas()) && Arrays.equals(this.getFeatures(), a.getFeatures());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSentence(), this.getTags(), this.getLemmas(), this.getFeatures()});
    }
}

