/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import opennlp.model.AbstractEventStream;
import opennlp.model.Event;
import opennlp.tools.util.ObjectStream;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerContextGenerator;

public class FeaturizerEventStream
extends AbstractEventStream {
    private FeaturizerContextGenerator cg;
    private ObjectStream<FeatureSample> data;
    private Event[] events;
    private int ei;

    public FeaturizerEventStream(ObjectStream<FeatureSample> d, FeaturizerContextGenerator cg) {
        this.cg = cg;
        this.data = d;
        this.ei = 0;
        this.addNewEvents();
    }

    @Override
    public Event next() {
        this.hasNext();
        return this.events[this.ei++];
    }

    @Override
    public boolean hasNext() {
        if (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.ei < this.events.length;
    }

    private void addNewEvents() {
        FeatureSample sample;
        try {
            sample = this.data.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (sample != null) {
            this.events = new Event[sample.getSentence().length];
            String[] toksArray = sample.getSentence();
            String[] tagsArray = sample.getTags();
            String[] predsArray = sample.getFeatures();
            int el = this.events.length;
            for (int ei = 0; ei < el; ++ei) {
                this.events[ei] = new Event(predsArray[ei], this.cg.getContext(ei, toksArray, tagsArray, predsArray));
            }
        } else {
            this.events = new Event[0];
        }
    }
}

