/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import opennlp.model.AbstractModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.ArtifactSerializer;
import org.cogroo.dictionary.FeatureDictionary;
import org.cogroo.tools.featurizer.DefaultFeaturizerContextGenerator;
import org.cogroo.tools.featurizer.DefaultFeaturizerFactory;
import org.cogroo.tools.featurizer.DefaultFeaturizerSequenceValidator;
import org.cogroo.tools.featurizer.FeaturizerContextGenerator;
import org.cogroo.tools.featurizer.SetSerializer;
import org.cogroo.tools.featurizer.WordTag;

public abstract class FeaturizerFactory
extends BaseToolFactory {
    private static final String CG_FLAGS_PROPERTY = "cgFlags";
    protected FeatureDictionary featureDictionary;
    private Set<String> poisonedDictionaryTags = null;
    private String cgFlags;

    public FeaturizerFactory() {
    }

    public FeaturizerFactory(FeatureDictionary featureDictionary, String cgFlags) {
        this.init(featureDictionary, cgFlags);
    }

    protected void init(FeatureDictionary featureDictionary, String cgFlags) {
        this.featureDictionary = featureDictionary;
        this.cgFlags = cgFlags;
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        SetSerializer.register(serializers);
        return serializers;
    }

    @Override
    public Map<String, String> createManifestEntries() {
        Map<String, String> manifestEntries = super.createManifestEntries();
        if (this.getCGFlags() != null) {
            manifestEntries.put(CG_FLAGS_PROPERTY, this.getCGFlags());
        }
        return manifestEntries;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        return artifactMap;
    }

    public String getCGFlags() {
        if (this.cgFlags == null) {
            String prop;
            if (this.artifactProvider != null && (prop = this.artifactProvider.getManifestProperty(CG_FLAGS_PROPERTY)) != null) {
                this.cgFlags = prop;
            }
            if (this.cgFlags == null) {
                this.cgFlags = "wshnc";
            }
        }
        return this.cgFlags;
    }

    public FeatureDictionary getFeatureDictionary() {
        if (this.featureDictionary == null) {
            this.featureDictionary = this.loadFeatureDictionary();
        }
        return this.featureDictionary;
    }

    protected abstract FeatureDictionary loadFeatureDictionary();

    public Set<String> getDictionaryPoisonedTags() {
        return this.poisonedDictionaryTags;
    }

    public FeaturizerContextGenerator getFeaturizerContextGenerator() {
        return new DefaultFeaturizerContextGenerator(this.getCGFlags());
    }

    public SequenceValidator<WordTag> getSequenceValidator() {
        return new DefaultFeaturizerSequenceValidator(this.getFeatureDictionary(), this.getDictionaryPoisonedTags());
    }

    protected void validateFeatureDictionary() {
        FeatureDictionary dict = this.getFeatureDictionary();
        if (dict != null && dict instanceof Iterable) {
            FeatureDictionary posDict = dict;
            HashSet<String> dictTags = new HashSet<String>();
            HashSet<String> poisoned = new HashSet<String>();
            for (WordTag wt : (Iterable)((Object)posDict)) {
                dictTags.add(wt.getPostag());
            }
            HashSet<String> modelTags = new HashSet<String>();
            AbstractModel posModel = (AbstractModel)this.artifactProvider.getArtifact("featurizer.model");
            for (int i = 0; i < posModel.getNumOutcomes(); ++i) {
                modelTags.add(posModel.getOutcome(i));
            }
            for (String d : dictTags) {
                if (modelTags.contains(d)) continue;
                poisoned.add(d);
            }
            this.poisonedDictionaryTags = Collections.unmodifiableSet(poisoned);
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        this.validateFeatureDictionary();
    }

    public static FeaturizerFactory create(String subclassName, FeatureDictionary posDictionary, String cgFlags) throws InvalidFormatException {
        if (subclassName == null) {
            return new DefaultFeaturizerFactory(posDictionary, cgFlags);
        }
        FeaturizerFactory theFactory = ExtensionLoader.instantiateExtension(FeaturizerFactory.class, subclassName);
        theFactory.init(posDictionary, cgFlags);
        return theFactory;
    }
}

