/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.model.TrainUtil;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.TrainingParameters;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.Featurizer;
import org.cogroo.tools.featurizer.FeaturizerEventStream;
import org.cogroo.tools.featurizer.FeaturizerFactory;
import org.cogroo.tools.featurizer.FeaturizerModel;
import org.cogroo.tools.featurizer.WordTag;

public class FeaturizerME
implements Featurizer {
    public static final int DEFAULT_BEAM_SIZE = 10;
    protected BeamSearch<WordTag> beam;
    private Sequence bestSequence;
    protected MaxentModel model;

    public FeaturizerME(FeaturizerModel model, int beamSize) {
        FeaturizerFactory factory = model.getFactory();
        this.model = model.getFeaturizerModel();
        this.beam = new BeamSearch<WordTag>(beamSize, factory.getFeaturizerContextGenerator(), this.model, factory.getSequenceValidator(), 0);
    }

    public FeaturizerME(FeaturizerModel model) {
        this(model, 10);
    }

    @Override
    public String[] featurize(String[] toks, String[] tags) {
        this.bestSequence = this.beam.bestSequence((WordTag[])WordTag.create(toks, tags), new Object[0]);
        if (this.bestSequence != null) {
            List<String> c = this.bestSequence.getOutcomes();
            return c.toArray(new String[c.size()]);
        }
        throw new RuntimeException("Could not find best sequence for " + new POSSample(toks, tags));
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags) {
        return this.beam.bestSequences(10, (WordTag[])WordTag.create(sentence, tags), new Object[0]);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence, String[] tags, double minSequenceScore) {
        return this.beam.bestSequences(10, (WordTag[])WordTag.create(sentence, tags), null, minSequenceScore);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static FeaturizerModel train(String lang, ObjectStream<FeatureSample> in, TrainingParameters mlParams, FeaturizerFactory factory) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        FeaturizerEventStream es = new FeaturizerEventStream(in, factory.getFeaturizerContextGenerator());
        AbstractModel maxentModel = TrainUtil.train(es, mlParams.getSettings(), manifestInfoEntries);
        return new FeaturizerModel(lang, maxentModel, manifestInfoEntries, factory);
    }
}

