/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.postag;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.UncloseableInputStream;
import org.cogroo.tools.postag.PortuguesePOSContextGenerator;
import org.cogroo.tools.postag.PortuguesePOSSequenceValidator;

public class PortugueseFactory
extends POSTaggerFactory {
    private static final String EXTENDED_POSDICT = "EXTENDED_POSDICT";

    public PortugueseFactory() {
    }

    public PortugueseFactory(Dictionary ngramDictionary, TagDictionary posDictionary) {
        super(ngramDictionary, posDictionary);
    }

    @Override
    public SequenceValidator<String> getSequenceValidator() {
        return new PortuguesePOSSequenceValidator(this.getTagDictionary());
    }

    @Override
    public POSContextGenerator getPOSContextGenerator(int cacheSize) {
        return new PortuguesePOSContextGenerator(cacheSize, this.getDictionary());
    }

    @Override
    public POSContextGenerator getPOSContextGenerator() {
        return new PortuguesePOSContextGenerator(this.getDictionary());
    }

    @Override
    public TagDictionary getTagDictionary() {
        Object obj;
        if (this.posDictionary == null && this.artifactProvider != null && (obj = this.artifactProvider.getArtifact(EXTENDED_POSDICT)) != null) {
            this.posDictionary = (POSDictionary)this.artifactProvider.getArtifact(EXTENDED_POSDICT);
        }
        return this.posDictionary;
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        serializers.put(EXTENDED_POSDICT, new POSDictionarySerializer(this));
        return serializers;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.posDictionary != null) {
            artifactMap.put(EXTENDED_POSDICT, this.posDictionary);
        }
        return artifactMap;
    }

    @Override
    public TagDictionary createTagDictionary(InputStream in) throws InvalidFormatException, IOException {
        return super.createTagDictionary(in);
    }

    static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        private POSTaggerFactory factory;

        public POSDictionarySerializer(POSTaggerFactory factory) {
            this.factory = factory;
        }

        @Override
        public POSDictionary create(InputStream in) throws IOException, InvalidFormatException {
            return (POSDictionary)this.factory.createTagDictionary(new UncloseableInputStream(in));
        }

        @Override
        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

