/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.shallowparser;

import java.util.ArrayList;
import java.util.Arrays;
import opennlp.tools.util.Span;
import org.cogroo.tools.chunker2.ChunkerContextGenerator;
import org.cogroo.tools.featurizer.WordTag;

public class ShallowParserContextGenerator
implements ChunkerContextGenerator {
    public String[] getContext(int index, WordTag[] sequence, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence, priorDecisions);
    }

    @Override
    public String[] getContext(int index, WordTag[] sequence, String[] priorDecisions) {
        String[] toks = new String[sequence.length];
        String[] tags = new String[sequence.length];
        String[] chunks = new String[sequence.length];
        for (int i = 0; i < sequence.length; ++i) {
            toks[i] = sequence[i].getWord();
            String t = sequence[i].getPostag();
            int bar = t.indexOf("|");
            tags[i] = t.substring(0, bar);
            chunks[i] = t.substring(bar + 1);
        }
        return this.getContext(index, toks, tags, chunks, priorDecisions);
    }

    public String[] getContext(int i, String[] toks, String[] tags, String[] chks, String[] preds) {
        String c2;
        String t2;
        String w2;
        String c1;
        String t1;
        String w1;
        String p_1;
        String c_1;
        String t_1;
        String w_1;
        String p_2;
        String c_2;
        String t_2;
        String w_2;
        if (i < 2) {
            w_2 = "w_2=bos";
            t_2 = "t_2=bos";
            c_2 = "c_2=bos";
            p_2 = "p_2=bos";
        } else {
            w_2 = "w_2=" + toks[i - 2];
            t_2 = "t_2=" + tags[i - 2];
            c_2 = "c_2=" + chks[i - 2];
            p_2 = "p_2" + preds[i - 2];
        }
        if (i < 1) {
            w_1 = "w_1=bos";
            t_1 = "t_1=bos";
            c_1 = "c_1=bos";
            p_1 = "p_1=bos";
        } else {
            w_1 = "w_1=" + toks[i - 1];
            t_1 = "t_1=" + tags[i - 1];
            c_1 = "c_1=" + chks[i - 1];
            p_1 = "p_1=" + preds[i - 1];
        }
        String w0 = "w0=" + toks[i];
        String t0 = "t0=" + tags[i];
        String c0 = "c0=" + chks[i];
        if (i + 1 >= toks.length) {
            w1 = "w1=eos";
            t1 = "t1=eos";
            c1 = "c1=eos";
        } else {
            w1 = "w1=" + toks[i + 1];
            t1 = "t1=" + tags[i + 1];
            c1 = "c1=" + chks[i + 1];
        }
        if (i + 2 >= toks.length) {
            w2 = "w2=eos";
            t2 = "t2=eos";
            c2 = "c2=eos";
        } else {
            w2 = "w2=" + toks[i + 2];
            t2 = "t2=" + tags[i + 2];
            c2 = "c2=" + chks[i + 2];
        }
        Span[] chunkSpans = ShallowParserContextGenerator.phrasesAsSpanList(chks);
        Span[] predSpans = ShallowParserContextGenerator.phrasesAsSpanList(preds);
        int indexPreds = -1;
        for (int j = 0; j < predSpans.length; ++j) {
            if (!predSpans[j].contains(i - 1)) continue;
            indexPreds = j;
            break;
        }
        String ps_2 = indexPreds < 2 ? "ps_2=bos" : "ps_2=" + predSpans[indexPreds - 2].getType();
        String ps_1 = indexPreds < 1 ? "ps_1=bos" : "ps_1=" + predSpans[indexPreds - 1].getType();
        int indexChunks = -1;
        for (int j = 0; j < chunkSpans.length; ++j) {
            if (!chunkSpans[j].contains(i)) continue;
            indexChunks = j;
            break;
        }
        String cs_2 = indexChunks < 2 ? "cs_2=bos" : "cs_2=" + chunkSpans[indexChunks - 2].getType();
        String cs_1 = indexChunks < 1 ? "cs_1=bos" : "cs_1=" + chunkSpans[indexChunks - 1].getType();
        String cs0 = indexChunks >= 0 ? "cs0=" + chunkSpans[indexChunks].getType() : "cs0=bos";
        String cs1 = indexChunks + 1 >= chunkSpans.length ? "cs1=eos" : "cs1=" + chunkSpans[indexChunks + 1].getType();
        String cs2 = indexChunks + 2 >= chunkSpans.length ? "cs2=eos" : "cs2=" + chunkSpans[indexChunks + 1].getType();
        String[] features = new String[]{w_2, w_1, w0, w1, w2, w_1 + w0, w0 + w1, t_2, t_1, t0, t1, t2, t_2 + t_1, t_1 + t0, t0 + t1, t1 + t2, t_2 + t_1 + t0, t_1 + t0 + t1, t0 + t1 + t2, c_2, c_1, c0, c1, c2, c_2 + c_1, c_1 + c0, c0 + c1, c1 + c2, c_2 + c_1 + c0, c_1 + c0 + c1, c0 + c1 + c2, cs_2, cs_1, cs0, cs1, cs2, cs_2 + cs_1, cs_1 + cs0, cs0 + cs1, cs1 + cs2, cs_2 + cs_1 + cs0, cs_1 + cs0 + cs1, cs0 + cs1 + cs2, p_2, p_1, p_2 + p_1, ps_2, ps_1, ps_2 + ps_1, p_1 + t_2, p_1 + t_1, p_1 + t0, p_1 + t1, p_1 + t2, p_1 + t_2 + t_1, p_1 + t_1 + t0, p_1 + t0 + t1, p_1 + t1 + t2, p_1 + t_2 + t_1 + t0, p_1 + t_1 + t0 + t1, p_1 + t0 + t1 + t2, p_1 + c_2, p_1 + c_1, p_1 + c0, p_1 + c1, p_1 + c2, p_1 + c_2 + c_1, p_1 + c_1 + c0, p_1 + c0 + c1, p_1 + c1 + c2, p_1 + c_2 + c_1 + c0, p_1 + c_1 + c0 + c1, p_1 + c0 + c1 + c2, p_1 + w_2, p_1 + w_1, p_1 + w0, p_1 + w1, p_1 + w2, p_1 + w_1 + w0, p_1 + w0 + w1, t_2 + c_2, t_1 + c_1, t0 + c0, t1 + c1, t2 + c2};
        return features;
    }

    public static Span[] phrasesAsSpanList(String[] aChunksIn) {
        ArrayList<Span> phrases = new ArrayList<Span>(aChunksIn.length);
        String startTag = "";
        int startIndex = 0;
        boolean foundPhrase = false;
        String[] aChunks = Arrays.copyOf(aChunksIn, aChunksIn.length);
        for (int i = 0; i < aChunks.length; ++i) {
            if (!aChunks[i].equals("O")) continue;
            aChunks[i] = "B-O";
        }
        int cn = aChunks.length;
        for (int ci = 0; ci < cn; ++ci) {
            String pred = aChunks[ci];
            if (pred.startsWith("B-") || !pred.equals("I-" + startTag) && !pred.equals("O")) {
                if (foundPhrase) {
                    phrases.add(new Span(startIndex, ci, startTag));
                }
                startIndex = ci;
                startTag = pred.substring(2);
                foundPhrase = true;
                continue;
            }
            if (pred.equals("I-" + startTag) || !foundPhrase) continue;
            phrases.add(new Span(startIndex, ci, startTag));
            foundPhrase = false;
            startTag = "";
        }
        if (foundPhrase) {
            phrases.add(new Span(startIndex, aChunks.length, startTag));
        }
        return phrases.toArray(new Span[phrases.size()]);
    }
}

