/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.cogroo.addon.Resources;

public class LoggerImpl {
    public static final String lineSeparator = System.getProperty("line.separator");
    private static final String path = Resources.getProperty("LOG_FILE_PATTERN");
    private static boolean initialized = false;
    private static FileHandler handler;
    private static final Level defaultLevel;
    private static final String tempDir;
    private static final String homeDir;
    private static final String userName;

    private static void init() {
        if (!initialized) {
            try {
                LoggerImpl.createPath(path);
                handler = new FileHandler(LoggerImpl.replacePath(path), 100000, 5, true);
                handler.setFormatter(new SimpleFormatter());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        initialized = true;
    }

    public static String getPath() {
        return LoggerImpl.replacePath(path);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static Logger getLogger(String name) {
        LoggerImpl.init();
        Logger l = Logger.getLogger(name);
        l.addHandler(handler);
        l.setLevel(defaultLevel);
        return l;
    }

    private static String replacePath(String oriPath) {
        String newPath = oriPath.replace("%t", tempDir);
        newPath = newPath.replace("%h", homeDir);
        newPath = newPath.replace("%u", userName);
        try {
            newPath = new File(newPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newPath;
    }

    private static void createPath(String oriPath) {
        File parent = new File(LoggerImpl.replacePath(oriPath)).getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    private static String getTmpFolder() {
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.startsWith("/var/folders/")) {
            tmp = "/tmp/";
        }
        return tmp;
    }

    static {
        defaultLevel = Level.parse(Resources.getProperty("LOG_LEVEL"));
        tempDir = LoggerImpl.getTmpFolder();
        homeDir = System.getProperty("user.name");
        userName = System.getProperty("user.name");
    }
}

