/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.addon.conf;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;

public class DefaultConfiguration {
    public static final String CONFIGURATION_SERVICE = "com.sun.star.configuration.ConfigurationProvider";
    public static final String CONFIGURATION_READ_ONLY_VIEW = "com.sun.star.configuration.ConfigurationAccess";
    public static final String CONFIGURATION_UPDATABLE_VIEW = "com.sun.star.configuration.ConfigurationUpdateAccess";
    protected XMultiServiceFactory configProvider;

    public DefaultConfiguration(XComponentContext context) {
        XMultiServiceFactory factory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)context.getServiceManager());
        this.init(factory);
    }

    public DefaultConfiguration(XMultiServiceFactory factory) {
        this.init(factory);
    }

    protected void init(XMultiServiceFactory factory) {
        try {
            this.configProvider = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)factory.createInstance(CONFIGURATION_SERVICE));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Object getRootNode(String configPath, boolean readonly) {
        try {
            if (readonly) {
                PropertyValue path = new PropertyValue();
                path.Name = "nodepath";
                path.Value = configPath;
                Object[] args = new Object[]{path};
                return this.configProvider.createInstanceWithArguments(CONFIGURATION_READ_ONLY_VIEW, args);
            }
            PropertyValue aPathArgument = new PropertyValue();
            aPathArgument.Name = "nodepath";
            aPathArgument.Value = configPath;
            PropertyValue aModeArgument = new PropertyValue();
            aModeArgument.Name = "EnableAsync";
            aModeArgument.Value = new Boolean(true);
            Object[] args = new Object[]{aPathArgument, aModeArgument};
            return this.configProvider.createInstanceWithArguments(CONFIGURATION_UPDATABLE_VIEW, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getProperty(String configPath, String property) {
        Object theObject = null;
        try {
            Object root = this.getRootNode(configPath, true);
            XHierarchicalPropertySet props = (XHierarchicalPropertySet)UnoRuntime.queryInterface(XHierarchicalPropertySet.class, (Object)root);
            theObject = props.getHierarchicalPropertyValue(property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theObject;
    }

    public Object getChildNode(Object parent, String child) {
        Object theObject = null;
        try {
            XNameAccess childNode = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)parent);
            if (childNode.hasByName(child)) {
                theObject = childNode.getByName(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theObject;
    }

    public void setProperty(String configPath, String property, String value) {
        try {
            PropertyValue aPathArgument = new PropertyValue();
            aPathArgument.Name = "nodepath";
            aPathArgument.Value = configPath;
            PropertyValue aModeArgument = new PropertyValue();
            aModeArgument.Name = "EnableAsync";
            aModeArgument.Value = new Boolean(true);
            Object[] args = new Object[]{aPathArgument, aModeArgument};
            Object xViewRoot = this.configProvider.createInstanceWithArguments(CONFIGURATION_UPDATABLE_VIEW, args);
            XNameAccess props = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xViewRoot);
            if (props.hasByName(property)) {
                XPropertySet properties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xViewRoot);
                properties.setPropertyValue(property, (Object)value);
            } else {
                XNameContainer setUpdate = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xViewRoot);
                XSingleServiceFactory elementFactory = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)setUpdate);
                Object prop = elementFactory.createInstance();
                setUpdate.insertByName(property, prop);
            }
            this.commit(xViewRoot);
            ((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xViewRoot)).dispose();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void commit(Object root) {
        try {
            XChangesBatch xUpdateControl = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)root);
            xUpdateControl.commitChanges();
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
        }
    }

    public void dispose(Object obj) {
        ((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)obj)).dispose();
    }
}

