/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.community;

import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.XComponentContext;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.CogrooException;
import org.cogroo.addon.CogrooSingleton;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.Resources;
import org.cogroo.addon.i18n.I18nLabelsLoader;
import org.cogroo.addon.util.RestUtil;
import org.cogroo.addon.util.SecurityUtil;
import org.cogroo.entities.Mistake;
import org.cogroo.errorreport.ErrorReportAccess;
import org.cogroo.tools.errorreport.model.BadIntervention;
import org.cogroo.tools.errorreport.model.ErrorReport;
import org.cogroo.tools.errorreport.model.Span;

public class CommunityLogic {
    protected static Logger LOG = LoggerImpl.getLogger(CommunityLogic.class.getCanonicalName());
    private static final String ROOT = Resources.getProperty("COMMUNITY_ROOT");
    private final String selectedText;
    private List<Mistake> mistakes;
    private short[] classificationForBadIntervention;
    private String[] commentsForBadIntervention;
    private String[] interventions;
    private final String[] classificationTypes;
    private final String[] classificationTypesShort;
    private SortedSet<Omission> omissions;
    private final CogrooSingleton cogroo;
    private final BadIntervention.BadInterventionClassification[] classificationEnum;

    public CommunityLogic(XComponentContext context, String selectedText) {
        this.cogroo = CogrooSingleton.getInstance(context);
        this.selectedText = selectedText;
        this.mistakes = new ArrayList<Mistake>();
        this.cogroo.checkSentence(selectedText, this.mistakes);
        this.classificationForBadIntervention = new short[this.mistakes.size()];
        this.commentsForBadIntervention = new String[this.mistakes.size()];
        for (int i = 0; i < this.mistakes.size(); ++i) {
            this.classificationForBadIntervention[i] = 0;
            this.commentsForBadIntervention[i] = "";
        }
        this.classificationTypesShort = new String[]{I18nLabelsLoader.ADDON_BADINT_GOODINT_SHORT, I18nLabelsLoader.ADDON_BADINT_FALSEERROR_SHORT, I18nLabelsLoader.ADDON_BADINT_BADDESCRIPTION_SHORT, I18nLabelsLoader.ADDON_BADINT_BADSUGESTION_SHORT};
        this.classificationTypes = new String[]{I18nLabelsLoader.ADDON_BADINT_GOODINT, I18nLabelsLoader.ADDON_BADINT_FALSEERROR, I18nLabelsLoader.ADDON_BADINT_BADDESCRIPTION, I18nLabelsLoader.ADDON_BADINT_BADSUGESTION};
        this.classificationEnum = new BadIntervention.BadInterventionClassification[]{null, BadIntervention.BadInterventionClassification.FALSE_ERROR, BadIntervention.BadInterventionClassification.INAPPROPRIATE_DESCRIPTION, BadIntervention.BadInterventionClassification.INAPPROPRIATE_SUGGESTION};
        this.omissions = new TreeSet<Omission>();
    }

    public static String authenticateUser(String userName, String passwd, XPropertySet authProgressBar) throws CogrooException {
        String token = null;
        try {
            RestUtil rest = new RestUtil();
            HashMap<String, String> data = new HashMap<String, String>();
            SecurityUtil security = new SecurityUtil();
            authProgressBar.setPropertyValue("ProgressValue", (Object)20);
            KeyPair kp = security.genKeyPair();
            byte[] key = kp.getPublic().getEncoded();
            authProgressBar.setPropertyValue("ProgressValue", (Object)30);
            data.put("user", userName);
            data.put("pubKey", security.encodeURLSafe(key));
            Map<String, String> respData = rest.post(ROOT, "saveClientSecurityKey", data);
            String encodedEncryptedBKey = respData.get("encryptedSecretKey");
            if (encodedEncryptedBKey == null) {
                return null;
            }
            byte[] encryptedBKey = security.decodeURLSafe(encodedEncryptedBKey);
            authProgressBar.setPropertyValue("ProgressValue", (Object)40);
            data.clear();
            data.put("username", userName);
            data.put("encryptedPassword", security.encodeURLSafe(security.encrypt(kp.getPrivate(), encryptedBKey, passwd)));
            respData = rest.post(ROOT, "generateAuthenticationForUser", data);
            String encryptedToken = respData.get("token");
            if (encryptedToken == null) {
                return null;
            }
            byte[] tokenBytes = security.decrypt(kp.getPrivate(), encryptedBKey, security.decodeURLSafe(encryptedToken));
            token = new String(tokenBytes);
            authProgressBar.setPropertyValue("ProgressValue", (Object)50);
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, "InvalidKeyException should not happen.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        catch (com.sun.star.uno.Exception ex) {
            LOG.log(Level.SEVERE, "UNO Exception should not happen.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unexpected exception while authenticating user.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        return token;
    }

    public static String[] getCategoriesForUser(String userName, String token, XPropertySet authProgressBar) throws CogrooException {
        String[] categories = null;
        try {
            RestUtil rest = new RestUtil();
            HashMap<String, String> data = new HashMap<String, String>();
            SecurityUtil security = new SecurityUtil();
            KeyPair kp = security.genKeyPair();
            byte[] key = kp.getPublic().getEncoded();
            data.put("user", userName);
            data.put("pubKey", security.encodeURLSafe(key));
            authProgressBar.setPropertyValue("ProgressValue", (Object)70);
            Map<String, String> respData = rest.post(ROOT, "saveClientSecurityKey", data);
            String encodedEncryptedBKey = respData.get("encryptedSecretKey");
            byte[] encryptedBKey = security.decodeURLSafe(encodedEncryptedBKey);
            data.clear();
            data.put("username", userName);
            data.put("token", security.encodeURLSafe(security.encrypt(kp.getPrivate(), encryptedBKey, token)));
            authProgressBar.setPropertyValue("ProgressValue", (Object)80);
            respData = rest.post(ROOT, "getErrorCategoriesForUser", data);
            String cat = respData.get("categories");
            categories = cat.split("\\|");
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, "InvalidKeyException should not happen.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        catch (com.sun.star.uno.Exception ex) {
            LOG.log(Level.SEVERE, "UNO Exception should not happen.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        return categories;
    }

    public String submitErrorReport(String userName, String token, XPropertySet authProgressBar) throws CogrooException {
        String result = null;
        try {
            RestUtil rest = new RestUtil();
            HashMap<String, String> data = new HashMap<String, String>();
            SecurityUtil security = new SecurityUtil();
            KeyPair kp = security.genKeyPair();
            byte[] key = kp.getPublic().getEncoded();
            data.put("user", userName);
            data.put("pubKey", security.encodeURLSafe(key));
            authProgressBar.setPropertyValue("ProgressValue", (Object)30);
            Map<String, String> respData = rest.post(ROOT, "saveClientSecurityKey", data);
            String encodedEncryptedBKey = respData.get("encryptedSecretKey");
            byte[] encryptedBKey = security.decodeURLSafe(encodedEncryptedBKey);
            data.clear();
            data.put("username", userName);
            data.put("token", security.encodeURLSafe(security.encrypt(kp.getPrivate(), encryptedBKey, token)));
            data.put("error", SecurityUtil.encodeURLSafe(this.createErrorReportXML()));
            authProgressBar.setPropertyValue("ProgressValue", (Object)60);
            respData = rest.post(ROOT, "submitErrorReport", data);
            result = respData.get("result");
            rest.getGAImg(ROOT, "submitErrorReport");
            authProgressBar.setPropertyValue("ProgressValue", (Object)80);
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, "InvalidKeyException should not happen.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        catch (com.sun.star.uno.Exception ex) {
            LOG.log(Level.SEVERE, "UNO Exception should not happen.", ex);
            throw new CogrooException("internal_error", new String[]{ex.getLocalizedMessage()}, ex);
        }
        return result;
    }

    public boolean hasGrammarErrors() {
        return this.mistakes.size() > 0;
    }

    public String getText() {
        return this.selectedText;
    }

    public String getEscapedText() {
        return SecurityUtil.encodeURLSafe(this.selectedText);
    }

    public String getAnnotatedText() {
        StringBuilder annotatedText = new StringBuilder(this.selectedText);
        for (int i = this.mistakes.size() - 1; i >= 0; --i) {
            Mistake mistake = this.mistakes.get(i);
            String tag = this.classificationTypesShort[this.classificationForBadIntervention[i]];
            annotatedText.insert(mistake.getEnd(), "<" + tag + (i + 1) + "]");
            annotatedText.insert(mistake.getStart(), "[" + tag + (i + 1) + ">");
        }
        return annotatedText.toString();
    }

    public String getAnnotatedText(int errorID) {
        StringBuilder annotatedText = new StringBuilder(this.selectedText);
        Mistake mistake = this.mistakes.get(errorID);
        annotatedText.insert(mistake.getEnd(), "]");
        annotatedText.insert(mistake.getStart(), "[");
        return annotatedText.toString();
    }

    public String getOmissionsAnnotatedText() {
        StringBuilder annotatedText = new StringBuilder(this.selectedText);
        opennlp.tools.util.Span[] spans = new opennlp.tools.util.Span[this.omissions.size()];
        int i = 0;
        for (Omission o : this.omissions) {
            spans[i++] = o.getSpan();
        }
        for (i = this.omissions.size() - 1; i >= 0; --i) {
            annotatedText.insert(spans[i].getEnd(), "<o" + (i + 1) + "]");
            annotatedText.insert(spans[i].getStart(), "[o" + (i + 1) + ">");
        }
        return annotatedText.toString();
    }

    public String getOmissionsAnnotatedText(int index) {
        StringBuilder annotatedText = new StringBuilder(this.selectedText);
        opennlp.tools.util.Span[] spans = new opennlp.tools.util.Span[this.omissions.size()];
        int i = 0;
        for (Omission o : this.omissions) {
            spans[i++] = o.getSpan();
        }
        annotatedText.insert(spans[index].getEnd(), "]");
        annotatedText.insert(spans[index].getStart(), "[");
        return annotatedText.toString();
    }

    public boolean hasBadInterventions() {
        for (int i = 0; i < this.mistakes.size(); ++i) {
            BadIntervention.BadInterventionClassification classification = this.classificationEnum[this.classificationForBadIntervention[i]];
            if (classification == null) continue;
            return true;
        }
        return false;
    }

    public String[] getBadInterventions() {
        this.interventions = new String[this.mistakes.size()];
        for (int i = 0; i < this.mistakes.size(); ++i) {
            String tag = this.classificationTypesShort[this.classificationForBadIntervention[i]];
            this.interventions[i] = tag + (i + 1) + ": " + this.mistakes.get(i).getShortMessage();
        }
        return this.interventions;
    }

    public String getDetailsForBadIntervention(int badInterventionIndex) {
        Mistake m = this.mistakes.get(badInterventionIndex);
        StringBuilder sb = new StringBuilder();
        sb.append(I18nLabelsLoader.ADDON_BADINT_SUGESTIONS + " ");
        if (m.getSuggestions() != null && m.getSuggestions().length > 0) {
            for (int i = 0; i < m.getSuggestions().length - 1; ++i) {
                sb.append(m.getSuggestions()[i] + ", ");
            }
            sb.append(m.getSuggestions()[m.getSuggestions().length - 1]);
        }
        sb.append("\n");
        sb.append(m.getFullMessage());
        return sb.toString();
    }

    public short getClassificationForBadIntervention(short selectedItem) {
        return this.classificationForBadIntervention[selectedItem];
    }

    public void setClassificationForBadIntervention(short selectedItem, short classification) {
        this.classificationForBadIntervention[selectedItem] = classification;
    }

    public String getCommentsForBadIntervention(int selectedItem) {
        return this.commentsForBadIntervention[selectedItem];
    }

    public void setCommentsForBadIntervention(int selectedItem, String comment) {
        this.commentsForBadIntervention[selectedItem] = comment;
    }

    public String[] getClassifications() {
        return this.classificationTypes;
    }

    public boolean canAddOmission(int start, int end) {
        opennlp.tools.util.Span s = new opennlp.tools.util.Span(start, end);
        for (Omission o : this.omissions) {
            if (!o.getSpan().intersects(s)) continue;
            return false;
        }
        return true;
    }

    public Omission addOmission(int start, int end) {
        Omission o = new Omission(start, end);
        this.omissions.add(o);
        return o;
    }

    public boolean hasOmissions() {
        return this.omissions != null && !this.omissions.isEmpty();
    }

    public Omission[] getOmissions() {
        return this.omissions.toArray(new Omission[this.omissions.size()]);
    }

    public Omission getOmission(short selectedItem) {
        Omission o = null;
        Iterator it = this.omissions.iterator();
        for (int i = 0; i <= selectedItem; ++i) {
            o = (Omission)it.next();
        }
        return o;
    }

    public void removeOmission(short pos) {
        int i = 0;
        Omission toRemove = null;
        for (Omission o : this.omissions) {
            if (i == pos) {
                toRemove = o;
                break;
            }
            ++i;
        }
        if (toRemove != null) {
            this.omissions.remove(toRemove);
        }
    }

    public String[] getErrorGroups() {
        return this.cogroo.getCategories();
    }

    public void editOmission(short pos, String cat, String comment, String customCat, String replace) {
        Omission o = this.getOmission(pos);
        o.setCategory(cat);
        o.setComment(comment);
        o.setCustomCategory(customCat);
        o.setReplaceBy(replace);
    }

    public String createErrorReportXML() throws CogrooException {
        Span span;
        ErrorReport errorReport = new ErrorReport();
        errorReport.setVersion(I18nLabelsLoader.ADDON_VERSION);
        errorReport.setText(this.getText());
        errorReport.setBadInterventions(new ErrorReport.BadInterventions());
        errorReport.setOmissions(new ErrorReport.Omissions());
        for (int i = 0; i < this.mistakes.size(); ++i) {
            BadIntervention.BadInterventionClassification classification = this.classificationEnum[this.classificationForBadIntervention[i]];
            if (classification == null) continue;
            BadIntervention bi = new BadIntervention();
            bi.setClassification(classification);
            bi.setComment(this.commentsForBadIntervention[i]);
            bi.setRule(this.mistakes.get(i).getRuleIdentifier());
            span = new Span();
            span.setStart(this.mistakes.get(i).getStart());
            span.setEnd(this.mistakes.get(i).getEnd());
            bi.setSpan(span);
            errorReport.getBadInterventions().getBadIntervention().add(bi);
        }
        Omission[] os = this.getOmissions();
        for (int i = 0; i < os.length; ++i) {
            org.cogroo.tools.errorreport.model.Omission o = new org.cogroo.tools.errorreport.model.Omission();
            o.setCategory(os[i].getCategory());
            o.setComment(os[i].getComment());
            o.setCustomCategory(os[i].getCustomCategory());
            o.setReplaceBy(os[i].getReplaceBy());
            span = new Span();
            span.setStart(os[i].getStart());
            span.setEnd(os[i].getEnd());
            o.setSpan(span);
            errorReport.getOmissions().getOmission().add(o);
        }
        try {
            return ErrorReportAccess.serialize((ErrorReport)errorReport);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, null, e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new CogrooException("community_communication_serialization", args, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Omission
    implements Comparable<Omission> {
        private opennlp.tools.util.Span span;
        private String category;
        private String customCategory;
        private String replaceBy;
        private String comment;

        public Omission(int start, int end) {
            this.span = new opennlp.tools.util.Span(start, end);
        }

        public String toString() {
            if (this.category == null) {
                return "[" + this.span.getCoveredText((CharSequence)CommunityLogic.this.selectedText) + "]";
            }
            return "[" + this.span.getCoveredText((CharSequence)CommunityLogic.this.selectedText) + "] " + this.category;
        }

        public String getReplaceBy() {
            return this.replaceBy;
        }

        public void setReplaceBy(String replaceBy) {
            this.replaceBy = replaceBy;
        }

        public String getCustomCategory() {
            return this.customCategory;
        }

        public void setCustomCategory(String customCategory) {
            this.customCategory = customCategory;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public opennlp.tools.util.Span getSpan() {
            return this.span;
        }

        public int getEnd() {
            return this.span.getEnd();
        }

        public int getStart() {
            return this.span.getStart();
        }

        @Override
        public int compareTo(Omission o) {
            return this.span.compareTo(o.getSpan());
        }
    }
}

