/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.dialogs.about;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XDispatch;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.Resources;
import org.cogroo.addon.addon.AbstractAddOn;
import org.cogroo.addon.addon.conf.AddOnConfiguration;
import org.cogroo.addon.dialogs.reporterror.DialogBuilder;
import org.cogroo.addon.i18n.I18nLabelsLoader;

public class About
extends AbstractAddOn {
    protected static Logger LOGGER = LoggerImpl.getLogger(About.class.getCanonicalName());
    public static final String PROTOCOL_PATH = "aboutDialog";
    protected XDialog dialog;
    protected XFixedText licenseView;
    protected XButton licenseButton;
    protected boolean liceneDisplayed = false;

    public About(XComponentContext context) {
        super(context);
    }

    protected void init() {
        try {
            DialogBuilder builder = new DialogBuilder(this.context, 200, 200, 180, 125, I18nLabelsLoader.ADDON_LABELS_ABOUT);
            AddOnConfiguration config = new AddOnConfiguration(this.context);
            String imageURL = config.getRootURL() + Resources.getProperty("ICON_ABOUT");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("About.init: imageURL: " + imageURL);
            }
            builder.addImage(imageURL, "about.image", 0, 0, 180, 45, true, (short)0);
            builder.addMultiLineLabel(I18nLabelsLoader.ADDON_NAME + LoggerImpl.lineSeparator + I18nLabelsLoader.ADDON_LABELS_VERSION + ": " + I18nLabelsLoader.ADDON_VERSION + LoggerImpl.lineSeparator + I18nLabelsLoader.ADDON_SITE + LoggerImpl.lineSeparator, "about", 2, 50, 176, 40);
            this.licenseButton = builder.addButton(I18nLabelsLoader.ADDON_LABELS_VIEW_LICENSE, "license.button", 35, 100, 50, 15);
            this.licenseButton.addActionListener(new XActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (About.this.liceneDisplayed) {
                        About.this.licenseView.setText("");
                        XWindow window = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)About.this.dialog);
                        Rectangle r = window.getPosSize();
                        window.setPosSize(r.X, r.Y, r.Width, r.Height - 400, (short)15);
                        About.this.licenseButton.setLabel(I18nLabelsLoader.ADDON_LABELS_VIEW_LICENSE);
                        About.this.liceneDisplayed = false;
                    } else {
                        XWindow window = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)About.this.dialog);
                        Rectangle r = window.getPosSize();
                        window.setPosSize(r.X, r.Y, r.Width, r.Height + 400, (short)15);
                        r = window.getPosSize();
                        About.this.licenseView.setText(About.this.getLicenseText());
                        About.this.licenseButton.setLabel(I18nLabelsLoader.ADDON_LABELS_HIDE_LICENSE);
                        About.this.liceneDisplayed = true;
                    }
                }

                public void disposing(EventObject arg0) {
                }
            });
            this.licenseView = builder.addMultiLineLabel("", "license.view", 2, 127, 176, 310);
            XButton button = builder.addButton("OK", "ok", 95, 100, 50, 15);
            button.addActionListener(new XActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    About.this.setVisible(false);
                }

                public void disposing(EventObject arg0) {
                }
            });
            this.dialog = builder.getDialog();
            this.dialog.execute();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Uncaught exception", e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("<<< About.init()");
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.init();
        } else if (this.dialog != null) {
            this.dialog.endExecute();
        }
    }

    public String getImplementationName() {
        return this.getClass().getName();
    }

    public void dispatch(URL url, PropertyValue[] arg1) {
        if (url.Protocol.equals("dk.abj.openoffice.addon:") && url.Path.equals(PROTOCOL_PATH)) {
            this.setVisible(true);
        }
    }

    public XDispatch queryDispatch(URL url, String arg1, int arg2) {
        if (url.Protocol.equals("dk.abj.openoffice.addon:") && url.Path.equals(PROTOCOL_PATH)) {
            return this;
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] arg0) {
        XDispatch[] lDispatcher = new XDispatch[arg0.length];
        for (int i = 0; i < arg0.length; ++i) {
            lDispatcher[i] = this.queryDispatch(arg0[i].FeatureURL, arg0[i].FrameName, arg0[i].SearchFlags);
        }
        return lDispatcher;
    }

    private String getLicenseText() {
        StringBuffer licenseText = new StringBuffer();
        AddOnConfiguration config = new AddOnConfiguration(this.context);
        String licenseFile = config.getRootFolder() + Resources.getProperty("LICENSE_ABOUT");
        try {
            LOGGER.fine("Will try to open license file: " + licenseFile);
            FileInputStream fis = new FileInputStream(new File(licenseFile));
            InputStreamReader in = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader reader = new BufferedReader(in);
            String line = reader.readLine();
            while (line != null) {
                licenseText.append(line + LoggerImpl.lineSeparator);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Uncaught exception", e);
        }
        return licenseText.toString();
    }
}

