/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.dialogs.reporterror;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XFixedHyperlink;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XTextListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.CogrooException;
import org.cogroo.addon.CogrooRuntimeException;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.Resources;
import org.cogroo.addon.community.CommunityLogic;
import org.cogroo.addon.dialogs.MessageBox;
import org.cogroo.addon.dialogs.reporterror.WizardDialog;
import org.cogroo.addon.i18n.I18nLabelsLoader;
import org.cogroo.addon.util.RestConnectionException;

public class ErrorReportDialog
extends WizardDialog {
    protected static Logger LOG = LoggerImpl.getLogger(ErrorReportDialog.class.getCanonicalName());
    private static final int STEP_LOGIN = 1;
    private static final int STEP_FALSE_ERRORS = 2;
    private static final int STEP_OMISSIONS = 3;
    private static final int STEP_THANKS = 4;
    private CommunityLogic theCommunityLogic;
    private volatile boolean isAuthenticated = false;
    private volatile boolean gotCommunicationError = false;
    private String nextButtonName;
    private String previousButtonName;
    private String cancelButtonName;
    private XFixedText authStatusLabel;
    private XPropertySet authProgressBar;
    private XTextComponent userNameText;
    private XTextComponent userPasswordText;
    private String authButton;
    private XListBox badIntListBox;
    private XTextComponent badIntDetails;
    private XListBox badIntClassificationDropBox;
    private XTextComponent badIntComments;
    private String badIntApplyButton;
    private XTextComponent badIntErrorsText;
    private XFixedText badIntCommentsLabel;
    private XTextComponent omissionsTextToSelect;
    private String omissionsClassifyButton;
    private XTextComponent omissionsTextWithErrors;
    private XListBox omissionsErrorList;
    private String omissionsExcludeButton;
    private XListBox omissionsCategoriesDropbox;
    private XTextComponent omissionsCategoryText;
    private XTextComponent omissionsReplaceText;
    private XTextComponent omissionsCommentsText;
    private XFixedText omissionsCategoriesLabel;
    private XFixedText omissionsReplaceLabel;
    private XFixedText omissionsCommentsLabel;
    private XFixedText omissionsCategoryLabel;
    private String omissionsApply;
    private XFixedText thanksStatusLabel;
    private XFixedHyperlink thanksReportLink;
    private XPropertySet thanksProgressBar;
    private static final int DEFAULT_DIALOG_WIDTH = 280;
    private static final int DEFAULT_DIALOG_HEIGHT = 300;
    private static final int DEFAULT_SIDE_PANE_WIDTH = 85;
    private static final int DEFAULT_PosX = 95;
    private static final int DEFAULT_WIDTH_LARGE = 175;

    public ErrorReportDialog(XComponentContext _xContext, XMultiComponentFactory _xMCF) {
        super(_xContext, _xMCF);
    }

    public void initialize(String selectedText) {
        LOG.finest(">>> initialize");
        try {
            this.theCommunityLogic = new CommunityLogic(this.m_xContext, selectedText);
            String[] propNames = new String[]{"Height", "Moveable", "Name", "PositionX", "PositionY", "Step", "TabIndex", "Title", "Width"};
            Object[] propValues = new Object[]{new Integer(300), Boolean.TRUE, I18nLabelsLoader.ADDON_REPORT_ERROR, new Integer(102), new Integer(41), new Integer(-1), new Short(0), I18nLabelsLoader.ADDON_REPORT_ERROR + " - CoGrOO Comunidade", new Integer(280)};
            super.initialize(propNames, propValues);
            this.createWindowPeer();
            this.addRoadmap(new RoadmapItemStateChangeListener(this.m_xMSFDialogModel));
            this.populateStep1();
            this.populateStep2();
            this.populateStep3();
            this.populateStep4();
            this.addButtons();
            new CheckTokenAndGetCategoriesThread().start();
            this.setCurrentStep(1);
            this.setControlsState();
            LOG.finest("<<< initialize");
        }
        catch (BasicErrorException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            throw new CogrooRuntimeException("internal_error", new String[]{e.getLocalizedMessage()});
        }
    }

    private void populateStep1() {
        this.insertRoadmapItem(0, true, I18nLabelsLoader.REPORT_STEP_LOGIN, 1);
        int y = 6;
        this.insertFixedTextBold(this, 95, y, 175, 1, I18nLabelsLoader.REPORT_STEP_LOGIN);
        this.insertMultilineFixedText(this, 95, y += 12, 175, 144, 1, I18nLabelsLoader.ADDON_LOGIN_INFO);
        this.insertFixedHyperlink(this, 95, y += 144, 175, 1, I18nLabelsLoader.ADDON_REPORT_FROM_BROWSER, Resources.getProperty("COMMUNITY_ROOT") + "/reports/new/" + this.theCommunityLogic.getEscapedText());
        this.insertFixedHyperlink(this, 95, y += 18, 175, 1, I18nLabelsLoader.ADDON_LOGIN_REGISTER, Resources.getProperty("COMMUNITY_ROOT") + "/register");
        this.insertFixedHyperlink(this, 95, y += 12, 175, 1, I18nLabelsLoader.ADDON_LOGIN_LICENSE, I18nLabelsLoader.ADDON_LOGIN_LICENSEURL);
        this.insertFixedText(this, 95, (y += 12) + 2, 40, 1, I18nLabelsLoader.ADDON_LOGIN_USER);
        String userName = this.getCommunityUsername();
        if (userName == null) {
            userName = "";
        }
        AuthUserPasswdTextListener textListener = new AuthUserPasswdTextListener();
        this.userNameText = this.insertEditField(textListener, this, 135, y, 60, 1, userName);
        this.insertFixedText(this, 95, (y += 14) + 2, 40, 1, I18nLabelsLoader.ADDON_LOGIN_PASSWORD);
        this.userPasswordText = this.insertSecretEditField(textListener, this, 135, y, 60, 1, "");
        this.authButton = this.insertButton(new AuthLoginButtonListener(), 205, (y += 14) - 12, 40, 1, I18nLabelsLoader.ADDON_LOGIN_ALLOW, (short)0);
        this.insertFixedText(this, 95, y += 4, 175, 1, I18nLabelsLoader.ADDON_LOGIN_STATUS);
        this.authStatusLabel = this.insertHiddenFixedStatusText(this, 135, y, 175, 1, I18nLabelsLoader.ADDON_LOGIN_STATUS_NOTAUTH, false);
        this.authProgressBar = this.insertProgressBar(95, 266, 175, 1, 100);
    }

    private void populateStep2() {
        this.insertRoadmapItem(1, true, I18nLabelsLoader.REPORT_STEP_FALSE_ERRORS, 2);
        int y = 6;
        this.insertFixedTextBold(this, 95, y, 175, 2, I18nLabelsLoader.REPORT_STEP_FALSE_ERRORS);
        this.insertMultilineFixedText(this, 95, y += 12, 175, 32, 2, I18nLabelsLoader.ADDON_BADINT_INFO);
        this.insertMultilineFixedText(this, 95, y += 28, 175, 16, 2, I18nLabelsLoader.ADDON_BADINT_ERRORSLIST);
        this.badIntListBox = this.insertListBox(new BadIntListSelectonListener(), 95, y += 20, 36, 175, 2, this.theCommunityLogic.getBadInterventions());
        this.insertFixedText(this, 95, y += 40, 175, 2, I18nLabelsLoader.ADDON_BADINT_ERRORSFOUND);
        this.badIntErrorsText = this.insertMultilineEditField(this, this, 95, y += 8, 36, 175, 2, "", true);
        this.insertFixedText(this, 95, y += 40, 175, 2, I18nLabelsLoader.ADDON_BADINT_DETAILS);
        this.badIntDetails = this.insertMultilineEditField(this, this, 95, y += 8, 36, 175, 2, "", true);
        this.insertFixedText(this, 95, (y += 40) + 2, 40, 2, I18nLabelsLoader.ADDON_BADINT_TYPE);
        this.badIntClassificationDropBox = this.insertDropBox(new BadIntClassificationDropBoxSelectionListener(), 135, y, 135, 2, this.theCommunityLogic.getClassifications());
        this.badIntCommentsLabel = this.insertFixedText(this, 95, y += 14, 40, 2, I18nLabelsLoader.ADDON_BADINT_COMMENTS);
        this.badIntComments = this.insertMultilineEditField(new BadIntCommentsTextListener(), this, 95, y += 12, 24, 175, 2, "", false);
        this.badIntApplyButton = this.insertButton(new BadIntApplyButtonListener(), 230, y += 28, 40, 2, I18nLabelsLoader.ADDON_BADINT_APPLY, (short)0);
        this.setIsControlEnable(this.badIntApplyButton, false);
    }

    private void populateStep3() {
        this.insertRoadmapItem(2, true, I18nLabelsLoader.REPORT_STEP_OMISSIONS, 3);
        OmissionTextListener textListener = new OmissionTextListener();
        int y = 6;
        this.insertFixedTextBold(this, 95, y, 175, 3, I18nLabelsLoader.REPORT_STEP_OMISSIONS);
        this.insertMultilineFixedText(this, 95, y += 12, 175, 16, 3, I18nLabelsLoader.ADDON_OMISSION_INFO);
        this.insertFixedText(this, 95, y += 20, 175, 3, I18nLabelsLoader.ADDON_OMISSION_SELECT);
        this.omissionsTextToSelect = this.insertMultilineEditField(this, this, 95, y += 12, 30, 175, 3, this.theCommunityLogic.getText(), true);
        this.omissionsClassifyButton = this.insertButton(new OmissionClassifyButtonListener(), 230, y += 32, 40, 3, I18nLabelsLoader.ADDON_OMISSION_CLASSIFY, (short)0);
        this.insertFixedText(this, 95, y += 8, 175, 3, I18nLabelsLoader.ADDON_OMISSION_CLASSIFIED_ERRORS);
        this.omissionsErrorList = this.insertListBox(new OmissionListSelectionListener(), 95, y += 8, 24, 175, 3, new String[0]);
        this.insertFixedText(this, 95, y += 28, 175, 3, I18nLabelsLoader.ADDON_OMISSION_SELECTED_OMISSION);
        this.omissionsTextWithErrors = this.insertMultilineEditField(this, this, 95, y += 8, 30, 175, 3, this.theCommunityLogic.getText(), true);
        this.omissionsCategoriesLabel = this.insertFixedText(this, 95, y += 34, 175, 3, I18nLabelsLoader.ADDON_OMISSION_CATEGORY);
        this.omissionsCategoriesDropbox = this.insertDropBox(new OmissionCategoryDropBoxSelectionListener(), 95, y += 8, 175, 3, new String[0]);
        this.omissionsCategoryLabel = this.insertFixedText(this, 95, (y += 14) + 2, 40, 3, I18nLabelsLoader.ADDON_OMISSION_CATEGORY_CUSTOM);
        this.omissionsCategoryText = this.insertEditField(textListener, this, 140, y, 130, 3, "");
        this.omissionsReplaceLabel = this.insertFixedText(this, 95, (y += 14) + 2, 40, 3, I18nLabelsLoader.ADDON_OMISSION_REPLACE_BY);
        this.omissionsReplaceText = this.insertEditField(textListener, this, 140, y, 130, 3, "");
        this.omissionsCommentsLabel = this.insertFixedText(this, 95, y += 14, 175, 3, I18nLabelsLoader.ADDON_OMISSION_COMMENTS);
        this.omissionsCommentsText = this.insertMultilineEditField(textListener, this, 95, y += 8, 24, 175, 3, "", false);
        this.omissionsApply = this.insertButton(new OmissionApplyButtonListener(), 230, y += 28, 40, 3, I18nLabelsLoader.ADDON_OMISSION_APPLY, (short)0);
        this.omissionsExcludeButton = this.insertButton(new OmissionExcludeButtonListener(), 190, y, 40, 3, I18nLabelsLoader.ADDON_OMISSION_EXCLUDE, (short)0);
    }

    private void populateStep4() {
        this.insertRoadmapItem(3, true, I18nLabelsLoader.REPORT_STEP_THANKS, 4);
        int y = 6;
        this.insertFixedTextBold(this, 95, y, 175, 4, I18nLabelsLoader.REPORT_STEP_THANKS);
        this.insertMultilineFixedText(this, 95, y += 12, 175, 40, 4, I18nLabelsLoader.ADDON_THANKS_MESSAGE);
        this.insertFixedText(this, 95, y += 52, 175, 4, I18nLabelsLoader.ADDON_THANKS_STATUS);
        this.thanksStatusLabel = this.insertHiddenFixedStatusText(this, 135, y, 175, 4, I18nLabelsLoader.ADDON_THANKS_STATUS, false);
        this.thanksReportLink = this.insertFixedHyperlink(this, 95, y += 12, 175, 4, I18nLabelsLoader.ADDON_THANKS_LINK, Resources.getProperty("COMMUNITY_ROOT") + "/reports");
        this.thanksProgressBar = this.insertProgressBar(95, 266, 175, 4, 100);
    }

    private void addButtons() {
        int y = 281;
        int x = 125;
        this.previousButtonName = this.insertButton(new PreviousActionListener(), x, y, 40, 0, I18nLabelsLoader.REPORT_STEP_BUTTONS_PREV, (short)0);
        this.nextButtonName = this.insertButton(new NextActionListener(), x += 50, y, 40, 0, I18nLabelsLoader.REPORT_STEP_BUTTONS_NEXT, (short)0);
        this.cancelButtonName = this.insertButton(this, x += 50, y, 40, 0, I18nLabelsLoader.REPORT_STEP_BUTTONS_CANCEL, (short)2);
    }

    private void configureStateAuth() {
        this.setIsControlEnable(this.authButton, false);
        if (this.isAuthenticated()) {
            this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_OK);
            this.setDefaultButton(this.nextButtonName, true);
            if (this.userPasswordText.getText() != null && this.userPasswordText.getText().length() == 0) {
                this.userPasswordText.setText("********");
            }
            this.setDefaultButton(this.authButton, false);
            this.setDefaultButton(this.cancelButtonName, false);
            this.setDefaultButton(this.nextButtonName, true);
        } else if (this.gotCommunicationError) {
            this.setIsControlEnable(this.authButton, true);
            this.setDefaultButton(this.cancelButtonName, true);
        }
    }

    private void configureStateBadInst() {
        if (this.badIntListBox.getItemCount() > 0) {
            this.badIntListBox.selectItemPos((short)0, true);
            this.setBadIntDetailsForSelectedItem((short)0);
            this.setIsControlEnable(this.badIntCommentsLabel, false);
            this.setIsControlEnable(this.badIntComments, false);
            this.badIntErrorsText.setText(this.theCommunityLogic.getAnnotatedText(0));
        }
    }

    private void configureStateOmissions() {
        if (this.omissionsErrorList.getItemCount() > 0) {
            this.omissionsErrorList.selectItemPos((short)0, true);
            this.setOmissionDetailsForSelectedItem((short)0);
        } else {
            this.enableOmissionDetails(false, false);
        }
    }

    private void setControlsState() {
        this.configureStateAuth();
        this.configureStateBadInst();
        this.configureStateOmissions();
        this.setEnabledSteps();
        this.setEnabledButtons();
    }

    private void setCurrentStep(int nNewID) {
        try {
            XPropertySet xDialogModelPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xMSFDialogModel);
            int nOldStep = this.getCurrentStep();
            if (nNewID != nOldStep) {
                xDialogModelPropertySet.setPropertyValue("Step", (Object)new Integer(nNewID));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private int getCurrentStep() {
        int step = -1;
        try {
            XPropertySet xDialogModelPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xMSFDialogModel);
            step = (Integer)xDialogModelPropertySet.getPropertyValue("Step");
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
        return step;
    }

    private void setIsStepEnabled(int step, boolean isEnabled) {
        try {
            Object oRoadmapItem = this.m_xRMIndexCont.getByIndex(step - 1);
            XPropertySet xRMItemPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oRoadmapItem);
            xRMItemPSet.setPropertyValue("Enabled", (Object)new Boolean(isEnabled));
        }
        catch (com.sun.star.uno.Exception e) {
            LOGGER.log(Level.SEVERE, "Error in setIsStepEnabled", e);
            throw new CogrooRuntimeException(e);
        }
    }

    private boolean isStepEnabled(int step) {
        if (step < 0) {
            return false;
        }
        boolean isStepEnabled = false;
        try {
            Object oRoadmapItem = this.m_xRMIndexCont.getByIndex(step - 1);
            XPropertySet xRMItemPSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oRoadmapItem);
            isStepEnabled = (Boolean)xRMItemPSet.getPropertyValue("Enabled");
        }
        catch (com.sun.star.uno.Exception e) {
            LOGGER.log(Level.SEVERE, "Error in isStepEnabled", e);
            throw new CogrooRuntimeException(e);
        }
        return isStepEnabled;
    }

    private void setEnabledSteps() {
        boolean isAuth = this.isAuthenticated();
        boolean hasFalseErrors = this.badIntListBox.getItemCount() > 0;
        int currentStep = this.getCurrentStep();
        boolean login = true;
        boolean falseErrors = false;
        boolean omissions = false;
        boolean thanks = false;
        if (currentStep == 4) {
            omissions = false;
            falseErrors = false;
            login = false;
            thanks = true;
        } else if (isAuth) {
            if (hasFalseErrors) {
                falseErrors = true;
            }
            omissions = true;
            login = true;
        }
        this.setIsStepEnabled(1, login);
        this.setIsStepEnabled(2, falseErrors);
        this.setIsStepEnabled(3, omissions);
        this.setIsStepEnabled(4, thanks);
    }

    private void setEnabledButtons() {
        int currentStep = this.getCurrentStep();
        if (currentStep < 0) {
            return;
        }
        boolean isPreviousEnabled = true;
        boolean isNextEnabled = true;
        if (this.getNextStep(currentStep) < 0 && currentStep != 4) {
            isNextEnabled = false;
        }
        if (this.getPreviousStep(currentStep) < 0) {
            isPreviousEnabled = false;
        }
        this.setIsControlEnable(this.previousButtonName, isPreviousEnabled);
        this.setIsControlEnable(this.nextButtonName, isNextEnabled);
        if (currentStep == 3) {
            this.setControlText(this.nextButtonName, I18nLabelsLoader.REPORT_STEP_BUTTONS_SUBMIT);
            if (this.theCommunityLogic.hasBadInterventions() || this.theCommunityLogic.hasOmissions()) {
                this.setIsControlEnable(this.nextButtonName, true);
            } else {
                this.setIsControlEnable(this.nextButtonName, false);
            }
        } else if (currentStep == 4) {
            this.setControlText(this.nextButtonName, I18nLabelsLoader.REPORT_STEP_BUTTONS_FINISH);
        } else {
            this.setControlText(this.nextButtonName, I18nLabelsLoader.REPORT_STEP_BUTTONS_NEXT);
        }
    }

    private int getNextStep(int currentStep) {
        int nextStep = -1;
        for (int i = currentStep + 1; i <= 4; ++i) {
            if (!this.isStepEnabled(i)) continue;
            nextStep = i;
            break;
        }
        return nextStep;
    }

    private int getPreviousStep(int currentStep) {
        int prevStep = -1;
        for (int i = currentStep - 1; i >= 1; --i) {
            if (!this.isStepEnabled(i)) continue;
            prevStep = i;
            break;
        }
        return prevStep;
    }

    private String getCommunityUsername() {
        String userName = Resources.getProperty("COMMUNITY_USERNAME");
        return userName;
    }

    private void saveCommunityUsername(String userName) {
        Resources.setProperty("COMMUNITY_USERNAME", userName);
    }

    private String getCommunityUserToken() {
        String userName = Resources.getProperty("COMMUNITY_USERTOKEN");
        return userName;
    }

    private void saveCommunityUserToken(String userToken) {
        Resources.setProperty("COMMUNITY_USERTOKEN", userToken);
    }

    private boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    private void setBadIntDetailsForSelectedItem(short selectedItem) {
        this.badIntDetails.setText(this.theCommunityLogic.getDetailsForBadIntervention(selectedItem));
        this.badIntClassificationDropBox.selectItemPos(this.theCommunityLogic.getClassificationForBadIntervention(selectedItem), true);
        this.badIntComments.setText(this.theCommunityLogic.getCommentsForBadIntervention(selectedItem));
        this.badIntErrorsText.setText(this.theCommunityLogic.getAnnotatedText(selectedItem));
    }

    private void updateOmissionCategories(String[] cat) {
        short itens = this.omissionsCategoriesDropbox.getItemCount();
        if (itens > 0) {
            this.omissionsCategoriesDropbox.removeItems((short)0, itens);
        }
        this.omissionsCategoriesDropbox.addItem(I18nLabelsLoader.ADDON_OMISSION_CATEGORY_CUSTOM, (short)0);
        this.omissionsCategoriesDropbox.addItem(I18nLabelsLoader.ADDON_OMISSION_CATEGORY_UNKNOWN, (short)1);
        this.omissionsCategoriesDropbox.addItems(cat, (short)2);
    }

    private void setOmissionDetailsForSelectedItem(short selectedItem) {
        CommunityLogic.Omission o = this.theCommunityLogic.getOmission(selectedItem);
        boolean isCustomCategory = false;
        if (o.getCategory() != null) {
            this.omissionsCategoriesDropbox.selectItem(o.getCategory(), true);
            this.omissionsCategoryText.setText("");
        } else if (o.getCustomCategory() != null) {
            this.omissionsCategoriesDropbox.selectItem(I18nLabelsLoader.ADDON_OMISSION_CATEGORY_CUSTOM, true);
            this.omissionsCategoryText.setText(o.getCustomCategory());
            isCustomCategory = true;
        }
        if (o.getReplaceBy() != null) {
            this.omissionsReplaceText.setText(o.getReplaceBy());
        } else {
            this.omissionsReplaceText.setText("");
        }
        if (o.getComment() != null) {
            this.omissionsCommentsText.setText(o.getComment());
        } else {
            this.omissionsCommentsText.setText("");
        }
        this.enableOmissionDetails(true, isCustomCategory);
    }

    private void enableOmissionDetails(boolean isEnable, boolean isCustomCategory) {
        this.setIsControlEnable(this.omissionsCategoriesLabel, isEnable);
        this.setIsControlEnable(this.omissionsCategoriesDropbox, isEnable);
        this.setIsControlEnable(this.omissionsCategoryLabel, isEnable && isCustomCategory);
        this.setIsControlEnable(this.omissionsCategoryText, isEnable && isCustomCategory);
        this.setIsControlEnable(this.omissionsReplaceLabel, isEnable);
        this.setIsControlEnable(this.omissionsReplaceText, isEnable);
        this.setIsControlEnable(this.omissionsCommentsLabel, isEnable);
        this.setIsControlEnable(this.omissionsCommentsText, isEnable);
        if (!isEnable) {
            this.omissionsReplaceText.setText("");
            this.omissionsCommentsText.setText("");
            this.omissionsCategoryText.setText("");
        }
    }

    protected void setIsControlEnable(Object control, boolean isEnable) {
        this.setModelProperties(this.toModel(control), new String[]{"Enabled"}, new Object[]{new Boolean(isEnable)});
    }

    protected void setIsControlEnable(String control, boolean isEnable) {
        this.setModelProperties(this.getModelByName(control), new String[]{"Enabled"}, new Object[]{new Boolean(isEnable)});
    }

    protected void setControlText(String control, String text) {
        this.setModelProperties(this.getModelByName(control), new String[]{"Label"}, new Object[]{text});
    }

    protected void setDefaultButton(String control, boolean isDefault) {
        this.setModelProperties(this.getModelByName(control), new String[]{"DefaultButton"}, new Object[]{new Boolean(isDefault)});
    }

    protected XControlModel toModel(Object control) {
        XControl xc = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)control);
        return xc.getModel();
    }

    protected boolean safeEquals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        if (b != null) {
            return b.equals(a);
        }
        return false;
    }

    private void applyBadInt() {
        if (this.badIntListBox.getSelectedItemPos() >= 0) {
            this.theCommunityLogic.setClassificationForBadIntervention(this.badIntListBox.getSelectedItemPos(), this.badIntClassificationDropBox.getSelectedItemPos());
            this.theCommunityLogic.setCommentsForBadIntervention(this.badIntListBox.getSelectedItemPos(), this.badIntComments.getText());
            this.badIntErrorsText.setText(this.theCommunityLogic.getAnnotatedText());
            short pos = this.badIntListBox.getSelectedItemPos();
            this.badIntListBox.removeItems(pos, (short)1);
            this.badIntListBox.addItem(this.theCommunityLogic.getBadInterventions()[pos], pos);
            this.badIntListBox.selectItemPos(pos, true);
            this.setIsControlEnable(this.badIntApplyButton, false);
        }
    }

    private void applyOmission() {
        short pos = this.omissionsErrorList.getSelectedItemPos();
        if (pos >= 0) {
            String cat = this.omissionsCategoriesDropbox.getSelectedItem();
            String customCat = null;
            if (cat.startsWith(I18nLabelsLoader.ADDON_OMISSION_CATEGORY_CUSTOM)) {
                customCat = this.omissionsCategoryText.getText();
                cat = null;
            }
            String comment = this.omissionsCommentsText.getText();
            String replace = this.omissionsReplaceText.getText();
            this.theCommunityLogic.editOmission(pos, cat, comment, customCat, replace);
            CommunityLogic.Omission[] o = this.theCommunityLogic.getOmissions();
            this.omissionsErrorList.removeItems((short)0, (short)o.length);
            o = this.theCommunityLogic.getOmissions();
            String[] os = new String[o.length];
            for (int i = 0; i < o.length; ++i) {
                CommunityLogic.Omission omission = o[i];
                os[i] = "o" + (i + 1) + ": " + omission.toString();
            }
            this.omissionsErrorList.addItems(os, (short)0);
            this.omissionsErrorList.selectItemPos(pos, true);
            this.setIsControlEnable(this.omissionsApply, false);
            this.setEnabledButtons();
        }
    }

    void applyDetails() {
        int step = this.getCurrentStep();
        if (step == 3) {
            this.applyOmission();
        } else if (step == 2) {
            this.applyBadInt();
        }
    }

    private static void showError(XComponentContext xContext, CogrooException ex) {
        MessageBox mb = new MessageBox(xContext);
        short result = mb.showMessageBox(I18nLabelsLoader.ADDON_REPORT_ERROR, ex.getLocalizedMessage() + "\n Mais em: " + LoggerImpl.getPath(), "warningbox", 1);
        if (result != 1) {
            LOGGER.fine("User canceled");
            return;
        }
        LOGGER.fine("Result: " + result);
    }

    private class SendReportThread
    extends Thread {
        private SendReportThread() {
        }

        public void run() {
            String userName = ErrorReportDialog.this.getCommunityUsername();
            String token = ErrorReportDialog.this.getCommunityUserToken();
            if (userName != null && userName.length() > 0 && token != null && token.length() > 0) {
                try {
                    ErrorReportDialog.this.thanksStatusLabel.setText(I18nLabelsLoader.ADDON_THANKS_STATUS_SENDING);
                    ErrorReportDialog.this.thanksProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(5));
                    try {
                        ErrorReportDialog.this.thanksStatusLabel.setText(I18nLabelsLoader.ADDON_THANKS_STATUS_SENDING);
                        String link = ErrorReportDialog.this.theCommunityLogic.submitErrorReport(userName, token, ErrorReportDialog.this.thanksProgressBar);
                        ErrorReportDialog.this.thanksStatusLabel.setText(I18nLabelsLoader.ADDON_THANKS_STATUS_DONE);
                        ErrorReportDialog.this.thanksProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(100));
                    }
                    catch (RestConnectionException ex) {
                        ErrorReportDialog.this.gotCommunicationError = true;
                        WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_THANKS_STATUS_ERROR);
                    }
                    catch (CogrooException ex) {
                        ErrorReportDialog.showError(ErrorReportDialog.this.m_xContext, ex);
                        ErrorReportDialog.this.gotCommunicationError = true;
                        WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_THANKS_STATUS_ERROR);
                    }
                    ErrorReportDialog.this.authProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(100));
                    ErrorReportDialog.this.setControlsState();
                }
                catch (com.sun.star.uno.Exception ex) {
                    WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                }
                ErrorReportDialog.this.setControlsState();
            }
        }
    }

    private class AuthenticateUserThread
    extends Thread {
        private AuthenticateUserThread() {
        }

        public void run() {
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.authButton, false);
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userNameText, false);
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userPasswordText, false);
            String userName = ErrorReportDialog.this.userNameText.getText();
            String passwd = ErrorReportDialog.this.userPasswordText.getText();
            try {
                String token = null;
                ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_NOTAUTH);
                ErrorReportDialog.this.authProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(5));
                try {
                    token = CommunityLogic.authenticateUser(userName, passwd, ErrorReportDialog.this.authProgressBar);
                    if (token != null) {
                        ErrorReportDialog.this.isAuthenticated = true;
                        ErrorReportDialog.this.saveCommunityUserToken(token);
                        ErrorReportDialog.this.saveCommunityUsername(userName);
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_OK);
                        String[] categories = CommunityLogic.getCategoriesForUser(userName, token, ErrorReportDialog.this.authProgressBar);
                        ErrorReportDialog.this.updateOmissionCategories(categories);
                        ErrorReportDialog.this.setDefaultButton(ErrorReportDialog.this.nextButtonName, true);
                    } else {
                        ErrorReportDialog.this.isAuthenticated = false;
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_INVALIDUSER);
                        ErrorReportDialog.this.setDefaultButton(ErrorReportDialog.this.authButton, true);
                        ErrorReportDialog.this.setDefaultButton(ErrorReportDialog.this.nextButtonName, false);
                        ErrorReportDialog.this.setEnabledButtons();
                    }
                }
                catch (RestConnectionException ex) {
                    ErrorReportDialog.this.gotCommunicationError = true;
                    WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                    ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_COMMUNICATIONERROR);
                }
                catch (CogrooException ex) {
                    WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                    ErrorReportDialog.showError(ErrorReportDialog.this.m_xContext, ex);
                    ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_INVALIDUSER);
                }
                ErrorReportDialog.this.authProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(100));
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userNameText, true);
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userPasswordText, true);
                ErrorReportDialog.this.setControlsState();
            }
            catch (com.sun.star.uno.Exception ex) {
                WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private class CheckTokenAndGetCategoriesThread
    extends Thread {
        private CheckTokenAndGetCategoriesThread() {
        }

        public void run() {
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.authButton, false);
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userNameText, false);
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userPasswordText, false);
            String userName = ErrorReportDialog.this.getCommunityUsername();
            String token = ErrorReportDialog.this.getCommunityUserToken();
            if (userName != null && userName.length() > 0 && token != null && token.length() > 0) {
                try {
                    ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_NOTAUTH);
                    ErrorReportDialog.this.authProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(5));
                    try {
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_OK);
                        ErrorReportDialog.this.isAuthenticated = false;
                        String[] categories = CommunityLogic.getCategoriesForUser(userName, token, ErrorReportDialog.this.authProgressBar);
                        if (categories != null && categories.length > 0) {
                            ErrorReportDialog.this.isAuthenticated = true;
                        }
                        ErrorReportDialog.this.updateOmissionCategories(categories);
                    }
                    catch (RestConnectionException ex) {
                        ErrorReportDialog.this.gotCommunicationError = true;
                        WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_COMMUNICATIONERROR);
                    }
                    catch (CogrooException ex) {
                        WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                        ErrorReportDialog.this.authStatusLabel.setText(I18nLabelsLoader.ADDON_LOGIN_STATUS_INVALIDUSER);
                    }
                    ErrorReportDialog.this.authProgressBar.setPropertyValue("ProgressValue", (Object)new Integer(100));
                    ErrorReportDialog.this.setControlsState();
                }
                catch (com.sun.star.uno.Exception ex) {
                    WizardDialog.LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userNameText, true);
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.userPasswordText, true);
        }
    }

    protected class RoadmapItemStateChangeListener
    implements XItemListener {
        protected XMultiServiceFactory m_xMSFDialogModel;

        public RoadmapItemStateChangeListener(XMultiServiceFactory xMSFDialogModel) {
            this.m_xMSFDialogModel = xMSFDialogModel;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            try {
                int nNewID = itemEvent.ItemId;
                XPropertySet xDialogModelPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xMSFDialogModel);
                int nOldStep = (Integer)xDialogModelPropertySet.getPropertyValue("Step");
                if (nNewID != nOldStep) {
                    ErrorReportDialog.this.applyDetails();
                    xDialogModelPropertySet.setPropertyValue("Step", (Object)new Integer(nNewID));
                    ErrorReportDialog.this.setEnabledSteps();
                    ErrorReportDialog.this.setEnabledButtons();
                }
            }
            catch (com.sun.star.uno.Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }

    private class NextActionListener
    implements XActionListener {
        private NextActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            ErrorReportDialog.this.applyDetails();
            int currentStep = ErrorReportDialog.this.getCurrentStep();
            int nextStep = ErrorReportDialog.this.getNextStep(currentStep);
            if (currentStep == 4) {
                ErrorReportDialog.this.endExecute();
            } else if (currentStep == 3) {
                ErrorReportDialog.this.setCurrentStep(4);
                new SendReportThread().start();
            } else if (nextStep >= 0) {
                ErrorReportDialog.this.setCurrentStep(nextStep);
            }
            ErrorReportDialog.this.setEnabledSteps();
            ErrorReportDialog.this.setEnabledButtons();
            ErrorReportDialog.this.setDefaultButton(ErrorReportDialog.this.nextButtonName, true);
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class PreviousActionListener
    implements XActionListener {
        private PreviousActionListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            ErrorReportDialog.this.applyDetails();
            int currentStep = ErrorReportDialog.this.getCurrentStep();
            int prevStep = ErrorReportDialog.this.getPreviousStep(currentStep);
            if (prevStep >= 0) {
                ErrorReportDialog.this.setCurrentStep(prevStep);
            }
            ErrorReportDialog.this.setEnabledSteps();
            ErrorReportDialog.this.setEnabledButtons();
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class OmissionTextListener
    implements XTextListener {
        private OmissionTextListener() {
        }

        public void textChanged(TextEvent arg0) {
            boolean changed = false;
            CommunityLogic.Omission o = ErrorReportDialog.this.theCommunityLogic.getOmission(ErrorReportDialog.this.omissionsErrorList.getSelectedItemPos());
            if (o == null) {
                return;
            }
            if (!ErrorReportDialog.this.safeEquals(ErrorReportDialog.this.omissionsCategoryText.getText(), o.getCustomCategory())) {
                changed = true;
            }
            if (!ErrorReportDialog.this.safeEquals(ErrorReportDialog.this.omissionsReplaceText.getText(), o.getReplaceBy())) {
                changed = true;
            }
            if (!ErrorReportDialog.this.safeEquals(ErrorReportDialog.this.omissionsCommentsText.getText(), o.getComment())) {
                changed = true;
            }
            if (changed) {
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.omissionsApply, true);
            }
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class OmissionApplyButtonListener
    implements XActionListener {
        private OmissionApplyButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            ErrorReportDialog.this.applyOmission();
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class OmissionExcludeButtonListener
    implements XActionListener {
        private OmissionExcludeButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            short pos = ErrorReportDialog.this.omissionsErrorList.getSelectedItemPos();
            if (pos >= 0) {
                CommunityLogic.Omission[] omissions = ErrorReportDialog.this.theCommunityLogic.getOmissions();
                ErrorReportDialog.this.omissionsErrorList.removeItems((short)0, (short)omissions.length);
                ErrorReportDialog.this.theCommunityLogic.removeOmission(pos);
                omissions = ErrorReportDialog.this.theCommunityLogic.getOmissions();
                String[] os = new String[omissions.length];
                for (int i = 0; i < omissions.length; ++i) {
                    CommunityLogic.Omission omission = omissions[i];
                    os[i] = "o" + (i + 1) + ": " + omission.toString();
                }
                ErrorReportDialog.this.omissionsErrorList.addItems(os, (short)0);
                ErrorReportDialog.this.omissionsTextWithErrors.setText(ErrorReportDialog.this.theCommunityLogic.getOmissionsAnnotatedText());
                if (ErrorReportDialog.this.omissionsErrorList.getItemCount() > 0) {
                    ErrorReportDialog.this.omissionsErrorList.selectItemPos((short)0, true);
                }
            }
            ErrorReportDialog.this.configureStateOmissions();
            ErrorReportDialog.this.setEnabledButtons();
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class OmissionClassifyButtonListener
    implements XActionListener {
        private OmissionClassifyButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                int start = ((ErrorReportDialog)ErrorReportDialog.this).omissionsTextToSelect.getSelection().Min;
                int end = ((ErrorReportDialog)ErrorReportDialog.this).omissionsTextToSelect.getSelection().Max;
                if (end - start > 0 && ErrorReportDialog.this.theCommunityLogic.canAddOmission(start, end)) {
                    CommunityLogic.Omission[] omissions = ErrorReportDialog.this.theCommunityLogic.getOmissions();
                    ErrorReportDialog.this.omissionsErrorList.removeItems((short)0, (short)omissions.length);
                    CommunityLogic.Omission o = ErrorReportDialog.this.theCommunityLogic.addOmission(start, end);
                    omissions = ErrorReportDialog.this.theCommunityLogic.getOmissions();
                    int pos = -1;
                    String[] os = new String[omissions.length];
                    for (int i = 0; i < omissions.length; ++i) {
                        CommunityLogic.Omission omission = omissions[i];
                        if (omission.equals(o)) {
                            pos = i;
                        }
                        os[i] = "o" + (i + 1) + ": " + omission.toString();
                    }
                    ErrorReportDialog.this.omissionsErrorList.addItems(os, (short)0);
                    ErrorReportDialog.this.omissionsErrorList.selectItemPos((short)pos, true);
                    ErrorReportDialog.this.omissionsTextWithErrors.setText(ErrorReportDialog.this.theCommunityLogic.getOmissionsAnnotatedText(pos));
                }
            }
            catch (Exception e) {
                WizardDialog.LOGGER.log(Level.SEVERE, null, e);
            }
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class OmissionListSelectionListener
    implements XItemListener {
        private OmissionListSelectionListener() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            short selectedItem = ErrorReportDialog.this.omissionsErrorList.getSelectedItemPos();
            ErrorReportDialog.this.setOmissionDetailsForSelectedItem(selectedItem);
            ErrorReportDialog.this.omissionsTextWithErrors.setText(ErrorReportDialog.this.theCommunityLogic.getOmissionsAnnotatedText(selectedItem));
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class OmissionCategoryDropBoxSelectionListener
    implements XItemListener {
        private OmissionCategoryDropBoxSelectionListener() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            String selectedItem = ErrorReportDialog.this.omissionsCategoriesDropbox.getSelectedItem();
            if (selectedItem.startsWith(I18nLabelsLoader.ADDON_OMISSION_CATEGORY_CUSTOM)) {
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.omissionsCategoryText, true);
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.omissionsCategoryLabel, true);
            } else {
                ErrorReportDialog.this.omissionsCategoryText.setText("");
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.omissionsCategoryText, false);
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.omissionsCategoryLabel, false);
            }
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class BadIntClassificationDropBoxSelectionListener
    implements XItemListener {
        private BadIntClassificationDropBoxSelectionListener() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            short pos = ErrorReportDialog.this.badIntClassificationDropBox.getSelectedItemPos();
            if (pos != ErrorReportDialog.this.theCommunityLogic.getClassificationForBadIntervention(ErrorReportDialog.this.badIntListBox.getSelectedItemPos())) {
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.badIntApplyButton, true);
            }
            boolean commentsEnabled = true;
            if (pos == 0) {
                commentsEnabled = false;
                ErrorReportDialog.this.badIntComments.setText("");
            }
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.badIntCommentsLabel, commentsEnabled);
            ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.badIntComments, commentsEnabled);
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class BadIntCommentsTextListener
    implements XTextListener {
        private BadIntCommentsTextListener() {
        }

        public void textChanged(TextEvent arg0) {
            if (!ErrorReportDialog.this.badIntComments.getText().equals(ErrorReportDialog.this.theCommunityLogic.getCommentsForBadIntervention(ErrorReportDialog.this.badIntListBox.getSelectedItemPos()))) {
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.badIntApplyButton, true);
            }
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class BadIntListSelectonListener
    implements XItemListener {
        private BadIntListSelectonListener() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            short selectedItem = ErrorReportDialog.this.badIntListBox.getSelectedItemPos();
            ErrorReportDialog.this.setBadIntDetailsForSelectedItem(selectedItem);
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class BadIntApplyButtonListener
    implements XActionListener {
        private BadIntApplyButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            ErrorReportDialog.this.applyBadInt();
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class AuthUserPasswdTextListener
    implements XTextListener {
        private AuthUserPasswdTextListener() {
        }

        public void textChanged(TextEvent arg0) {
            boolean isUserEntered;
            String lastUser = ErrorReportDialog.this.getCommunityUsername();
            String passwd = ErrorReportDialog.this.userPasswordText.getText();
            String user = ErrorReportDialog.this.userNameText.getText();
            boolean isPasswdEntered = passwd.length() > 0;
            boolean bl = isUserEntered = user.length() > 0;
            if (isUserEntered && isPasswdEntered) {
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.authButton, true);
                ErrorReportDialog.this.setDefaultButton(ErrorReportDialog.this.authButton, true);
            } else {
                ErrorReportDialog.this.setIsControlEnable(ErrorReportDialog.this.authButton, false);
            }
        }

        public void disposing(EventObject arg0) {
        }
    }

    private class AuthLoginButtonListener
    implements XActionListener {
        private AuthLoginButtonListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            new AuthenticateUserThread().start();
        }

        public void disposing(EventObject arg0) {
        }
    }
}

