/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.cogroo.addon.LoggerImpl;

public class SecurityUtil {
    private static final String UTF8 = "UTF-8";
    protected static Logger LOG = LoggerImpl.getLogger(SecurityUtil.class.getCanonicalName());
    private static final int RSAKEYSIZE = 1024;

    public byte[] encrypt(PrivateKey privateKey, byte[] encryptedSecretKey, String data) throws InvalidKeyException {
        byte[] encryptedData = null;
        try {
            byte[] chave = privateKey.getEncoded();
            Cipher rsacf = Cipher.getInstance("RSA");
            rsacf.init(2, privateKey);
            byte[] secretKey = rsacf.doFinal(encryptedSecretKey);
            encryptedData = this.encrypt(secretKey, data);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception encrypting data", e);
        }
        return encryptedData;
    }

    private byte[] encrypt(byte[] secretKey, String data) throws InvalidKeyException {
        byte[] encryptedData = null;
        try {
            Cipher aescf = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivspec = new IvParameterSpec(new byte[16]);
            aescf.init(1, (Key)new SecretKeySpec(secretKey, "AES"), ivspec);
            encryptedData = aescf.doFinal(data.getBytes(UTF8));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception encrypting data", e);
        }
        return encryptedData;
    }

    private byte[] decryptSecretKey(PrivateKey privatekey, byte[] encryptedSecretKey) {
        byte[] result = null;
        try {
            Cipher rsacf = Cipher.getInstance("RSA");
            rsacf.init(2, privatekey);
            result = rsacf.doFinal(encryptedSecretKey);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error", e);
        }
        return result;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptedSecretKey, byte[] encryptedText) {
        byte[] text = null;
        try {
            byte[] secretKey = this.decryptSecretKey(privateKey, encryptedSecretKey);
            text = this.decrypt(secretKey, encryptedText);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Should not happen", e);
        }
        return text;
    }

    private byte[] decrypt(byte[] secretKey, byte[] encryptedText) {
        byte[] text = null;
        try {
            Cipher aescf = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivspec = new IvParameterSpec(new byte[16]);
            aescf.init(2, (Key)new SecretKeySpec(secretKey, "AES"), ivspec);
            text = aescf.doFinal(encryptedText);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Should not happen", e);
        }
        return text;
    }

    public KeyPair genKeyPair() {
        KeyPair kpr = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4));
            kpr = kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "Error generating key pair", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.log(Level.SEVERE, "Error generating key pair", e);
        }
        return kpr;
    }

    public String encode(byte[] key) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])key, (boolean)false));
    }

    public static String encodeURLSafe(String data) {
        String ret = null;
        try {
            ret = URLEncoder.encode(data, UTF8);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Should not happen", e);
        }
        return ret;
    }

    public String encodeURLSafe(byte[] key) {
        String encKey = null;
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("encode 01: key " + Arrays.toString(key));
            }
            String value = this.encode(key);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("encode 02 value: " + value);
            }
            encKey = URLEncoder.encode(value, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "Should not happen", e);
        }
        return encKey;
    }

    public byte[] decodeURLSafe(String encoded) {
        byte[] bytes = null;
        try {
            bytes = Base64.decodeBase64((byte[])URLDecoder.decode(encoded, UTF8).getBytes(UTF8));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error decoding string: " + encoded, e);
        }
        return bytes;
    }

    public synchronized String encrypt(String plaintext) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
            md.update(plaintext.getBytes(UTF8));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Should not happen!", e);
        }
        byte[] raw = md.digest();
        return this.encode(raw);
    }
}

