/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon;

import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.addon.conf.AddOnConfiguration;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.analyzer.ComponentFactory;
import org.cogroo.analyzer.Pipe;
import org.cogroo.checker.CheckDocument;
import org.cogroo.checker.GrammarChecker;
import org.cogroo.entities.Mistake;
import org.cogroo.text.Sentence;
import org.cogroo.tools.checker.rules.model.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CogrooSingleton {
    private static GrammarChecker COGROO;
    private static CogrooSingleton instance;
    protected static Logger LOGGER;
    private XComponentContext context;
    private String root = null;
    private final Object flag = new Object();
    private List<Rule> rules = null;

    private CogrooSingleton() {
    }

    public static synchronized CogrooSingleton getInstance(XComponentContext context) {
        if (instance == null) {
            instance = new CogrooSingleton();
            instance.init(context);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRoot() {
        if (this.root == null) {
            Object object = this.flag;
            synchronized (object) {
                AddOnConfiguration config = new AddOnConfiguration(this.context);
                try {
                    File f = config.getDataFolder();
                    this.root = f.getCanonicalPath();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed getting execution path.", e);
                }
            }
        }
        return this.root;
    }

    private void init(XComponentContext context) {
        this.context = context;
        String home = this.getRoot();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Will start CoGrOO using home path: " + home);
        }
        try {
            ComponentFactory factory = ComponentFactory.create((Locale)new Locale("pt", "BR"));
            Pipe pipe = (Pipe)factory.createPipe();
            COGROO = new GrammarChecker((Analyzer)pipe);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Error in CoGrOO initialization.", e);
        }
    }

    public synchronized int checkSentence(String paraText, List<Mistake> outMistakes) {
        int end = -1;
        try {
            CheckDocument document = new CheckDocument();
            document.setText(paraText);
            COGROO.analyze(document);
            if (document.getSentences() != null && document.getSentences().size() > 0) {
                end = ((Sentence)document.getSentences().get(0)).getEnd();
                outMistakes.addAll(document.getMistakes());
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Internal error.", e);
        }
        return end;
    }

    public synchronized void ignoreRule(String ruleidentifier) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Will add rule to ignored list: " + ruleidentifier);
        }
        COGROO.ignoreRule(ruleidentifier);
    }

    public synchronized void resetIgnoredRules() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Will reset ignored rule list.");
        }
        COGROO.resetIgnoredRules();
    }

    public String[] getCategories() {
        String[] ret = null;
        return ret;
    }

    static {
        instance = null;
        LOGGER = LoggerImpl.getLogger(CogrooSingleton.class.getCanonicalName());
    }
}

