/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.Locale;
import com.sun.star.linguistic2.ProofreadingResult;
import com.sun.star.linguistic2.SingleProofreadingError;
import java.util.Arrays;

public class GCUtil {
    public static String getDebugString(ProofreadingResult value) {
        StringBuilder sb = new StringBuilder();
        sb.append("Total errors: ");
        if (value.aErrors != null) {
            sb.append(value.aErrors.length + "\n");
            for (SingleProofreadingError err : value.aErrors) {
                sb.append("Error [").append(err.nErrorStart).append(" to ").append(err.nErrorLength).append("]\n");
                sb.append("ShortComment [").append(err.aShortComment).append("]\n");
                sb.append("FullMessage [").append(err.aFullComment).append("]\n");
                sb.append("Suggestion ");
                if (err.aSuggestions != null && err.aSuggestions.length > 0) {
                    for (String suggestion : err.aSuggestions) {
                        sb.append("[").append(suggestion).append("]");
                    }
                    continue;
                }
                sb.append("[none]");
            }
        }
        return sb.toString();
    }

    public static String getDebugString(int[] arr) {
        return Arrays.toString(arr);
    }

    public static String getDebugString(PropertyValue[] arr) {
        StringBuffer b = new StringBuffer();
        for (PropertyValue prop : arr) {
            b.append(GCUtil.getDebugString(prop) + "; ");
        }
        return b.toString();
    }

    public static String getDebugString(PropertyValue property) {
        return property.toString();
    }

    public static String getDebugString(Locale[] arr) {
        StringBuffer b = new StringBuffer();
        for (Locale locale : arr) {
            b.append(GCUtil.getDebugString(locale) + "; ");
        }
        return b.toString();
    }

    public static String getDebugString(Locale locale) {
        StringBuffer sb = new StringBuffer();
        if (locale.Language != null && locale.Language.length() > 0) {
            sb.append(locale.Language);
        }
        if (locale.Country != null && locale.Country.length() > 0) {
            sb.append("_" + locale.Country);
        }
        if (locale.Variant != null && locale.Variant.length() > 0) {
            sb.append("_" + locale.Variant);
        }
        return sb.toString();
    }

    public static boolean isLocaleEqual(Locale first, Locale second) {
        return GCUtil.getDebugString(second).startsWith(GCUtil.getDebugString(first));
    }

    public static boolean isKnownLocale(Locale[] knownLocales, Locale locale) {
        for (Locale knownLocale : knownLocales) {
            if (!GCUtil.isLocaleEqual(knownLocale, locale)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        Locale a = new Locale("en", "US", "nabo");
        System.out.println(GCUtil.getDebugString(a));
        Locale b = new Locale("en", "US", null);
        System.out.println(GCUtil.getDebugString(b));
        Locale c = new Locale("en", "US", null);
        Locale br = new Locale("pt", "BR", null);
        Locale pt = new Locale("pt", "PT", null);
        Locale ar = new Locale("es", "AR", null);
        Locale pt_neutral = new Locale("pt", "PT", "");
        Locale[] list = new Locale[]{c, pt_neutral};
        System.out.println(GCUtil.getDebugString(c));
        System.out.println("a=b: " + GCUtil.isLocaleEqual(a, b));
        System.out.println("b=c: " + GCUtil.isLocaleEqual(b, c));
        System.out.println("isKnown br: " + GCUtil.isKnownLocale(list, br));
        System.out.println("isKnown br: " + GCUtil.isKnownLocale(list, pt));
        System.out.println("isKnown ar: " + GCUtil.isKnownLocale(list, ar));
    }
}

