/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStatusListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceDisplayName;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.linguistic2.ProofreadingResult;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.linguistic2.XLinguServiceEventBroadcaster;
import com.sun.star.linguistic2.XLinguServiceEventListener;
import com.sun.star.linguistic2.XProofreader;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.task.XJob;
import com.sun.star.task.XJobExecutor;
import com.sun.star.text.XTextDocument;
import com.sun.star.ui.XContextMenuInterception;
import com.sun.star.ui.XContextMenuInterceptor;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import java.util.ArrayList;
import java.util.List;
import org.cogroo.addon.CogrooSingleton;
import org.cogroo.addon.GCUtil;
import org.cogroo.addon.Resources;
import org.cogroo.addon.SingletonFactory;
import org.cogroo.addon.addon.contextmenu.ContextMenuInterceptor;
import org.cogroo.addon.dialogs.about.AboutThread;
import org.cogroo.addon.dialogs.reporterror.ErrorReportDialogThread;
import org.cogroo.addon.util.SelectedTextExtractor;
import org.cogroo.entities.Mistake;

public final class Main
extends WeakBase
implements XProofreader,
XServiceInfo,
XLinguServiceEventBroadcaster,
XJobExecutor,
XServiceDisplayName,
XInitialization,
XDispatch,
XDispatchProvider,
XJob {
    private XComponentContext m_xContext;
    private XFrame m_xFrame;
    private static final String m_implementationName = Main.class.getName();
    private static final String[] m_serviceNames = new String[]{"com.sun.star.linguistic2.Proofreader", "org.cogroo.addon.Main", "com.sun.star.frame.ProtocolHandler", "org.cogroo.addon.Job"};
    private List<XLinguServiceEventListener> xEventListeners = new ArrayList<XLinguServiceEventListener>();

    public Main(XComponentContext context) {
        this.changeContext(context);
    }

    public void changeContext(XComponentContext xCompContext) {
        this.m_xContext = xCompContext;
        Resources.changeContext(xCompContext);
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplementationName) {
        SingletonFactory xFactory = null;
        if (sImplementationName.equals(m_implementationName)) {
            xFactory = new SingletonFactory();
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey xRegistryKey) {
        return Factory.writeRegistryServiceInfo((String)m_implementationName, (String[])m_serviceNames, (XRegistryKey)xRegistryKey);
    }

    public Locale[] getLocales() {
        return new Locale[]{new Locale("pt", "BR", "")};
    }

    public boolean hasLocale(Locale aLocale) {
        return GCUtil.isKnownLocale(this.getLocales(), aLocale);
    }

    public boolean isSpellChecker() {
        return false;
    }

    public ProofreadingResult doProofreading(String docID, String paraText, Locale locale, int startOfSentencePos, int sugEndOfSentencePos, PropertyValue[] aLanguagePortions) throws IllegalArgumentException {
        ProofreadingResult result = new ProofreadingResult();
        result.nBehindEndOfSentencePosition = sugEndOfSentencePos - startOfSentencePos;
        result.xProofreader = this;
        result.aLocale = locale;
        result.aDocumentIdentifier = docID;
        result.aText = paraText;
        if (startOfSentencePos == sugEndOfSentencePos || paraText == null || paraText.trim().length() == 0) {
            return result;
        }
        ArrayList<Mistake> mistakeList = new ArrayList<Mistake>();
        int end = CogrooSingleton.getInstance(this.m_xContext).checkSentence(paraText.substring(startOfSentencePos), mistakeList);
        if (end > 0) {
            result.nBehindEndOfSentencePosition = startOfSentencePos + end;
        }
        ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
        for (Mistake mistake : mistakeList) {
            SingleProofreadingError e1 = new SingleProofreadingError();
            e1.nErrorType = 2;
            e1.aFullComment = mistake.getFullMessage();
            e1.aShortComment = mistake.getShortMessage();
            e1.aSuggestions = (String[])mistake.getSuggestions().clone();
            e1.nErrorStart = mistake.getStart() + startOfSentencePos;
            e1.nErrorLength = mistake.getEnd() - mistake.getStart();
            e1.aRuleIdentifier = mistake.getRuleIdentifier();
            errorList.add(e1);
        }
        result.aErrors = errorList.toArray(new SingleProofreadingError[errorList.size()]);
        return result;
    }

    public void ignoreRule(String aRuleIdentifier, Locale aLocale) throws IllegalArgumentException {
        CogrooSingleton.getInstance(this.m_xContext).ignoreRule(aRuleIdentifier);
    }

    public void resetIgnoreRules() {
        CogrooSingleton.getInstance(this.m_xContext).resetIgnoredRules();
    }

    public String getImplementationName() {
        return m_implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return Main.getServiceNames();
    }

    public static String[] getServiceNames() {
        return m_serviceNames;
    }

    public boolean addLinguServiceEventListener(XLinguServiceEventListener xLinEvLis) {
        boolean ret = false;
        if (xLinEvLis == null) {
            ret = false;
        } else {
            this.xEventListeners.add(xLinEvLis);
            ret = true;
        }
        return ret;
    }

    public boolean removeLinguServiceEventListener(XLinguServiceEventListener xLinEvLis) {
        boolean ret = false;
        if (xLinEvLis == null) {
            ret = false;
        } else if (this.xEventListeners.contains(xLinEvLis)) {
            this.xEventListeners.remove(xLinEvLis);
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public void trigger(String sEvent) {
        if (sEvent.equals("about")) {
            AboutThread aboutthread = new AboutThread(this.m_xContext);
            aboutthread.start();
        }
    }

    public String getServiceDisplayName(Locale arg0) {
        return "CoGrOO";
    }

    public void initialize(Object[] object) throws Exception {
        if (object.length > 0) {
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object[0]);
        }
    }

    public void dispatch(URL aURL, PropertyValue[] aArguments) {
        if (aURL.Protocol.compareTo("org.cogroo.addon:") == 0 && aURL.Path.compareTo("ReportError") == 0) {
            XTextDocument xDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.m_xFrame.getController().getModel());
            SelectedTextExtractor extractor = new SelectedTextExtractor(this.m_xContext, xDoc);
            ErrorReportDialogThread reporterrorthread = new ErrorReportDialogThread(this.m_xContext);
            reporterrorthread.setText(extractor.getSelectedText());
            reporterrorthread.start();
        }
    }

    public void addStatusListener(XStatusListener xControl, URL aURL) {
    }

    public void removeStatusListener(XStatusListener xControl, URL aURL) {
    }

    public XDispatch queryDispatch(URL aURL, String sTargetFrameName, int iSearchFlags) {
        if (aURL.Protocol.compareTo("org.cogroo.addon:") == 0 && aURL.Path.compareTo("ReportError") == 0) {
            return this;
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] seqDescriptors) {
        int nCount = seqDescriptors.length;
        XDispatch[] seqDispatcher = new XDispatch[seqDescriptors.length];
        for (int i = 0; i < nCount; ++i) {
            seqDispatcher[i] = this.queryDispatch(seqDescriptors[i].FeatureURL, seqDescriptors[i].FrameName, seqDescriptors[i].SearchFlags);
        }
        return seqDispatcher;
    }

    public Object execute(NamedValue[] args) throws IllegalArgumentException, Exception {
        XModel xModel = null;
        boolean correctEvent = false;
        for (NamedValue arg : args) {
            NamedValue[] values;
            if (!arg.Name.equals("Environment")) continue;
            for (NamedValue value : values = (NamedValue[])AnyConverter.toObject((Type)new Type("[]com.sun.star.beans.NamedValue"), (Object)arg.Value)) {
                if (value.Name.equals("EnvType") && value.Value.equals("DOCUMENTEVENT")) {
                    correctEvent = true;
                    continue;
                }
                if (value.Name.equals("EventName") || !value.Name.equals("Model")) continue;
                xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)value.Value);
            }
        }
        if (correctEvent) {
            ContextMenuInterceptor interceptor = new ContextMenuInterceptor();
            XContextMenuInterceptor xInterceptor = (XContextMenuInterceptor)UnoRuntime.queryInterface(XContextMenuInterceptor.class, (Object)interceptor);
            XController xController = xModel.getCurrentController();
            XContextMenuInterception xInterception = (XContextMenuInterception)UnoRuntime.queryInterface(XContextMenuInterception.class, (Object)xController);
            xInterception.registerContextMenuInterceptor(xInterceptor);
        }
        return null;
    }
}

