/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.addon.contextmenu;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ui.ContextMenuExecuteEvent;
import com.sun.star.ui.ContextMenuInterceptorAction;
import com.sun.star.ui.XContextMenuInterceptor;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.logging.Logger;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.i18n.I18nLabelsLoader;

public class ContextMenuInterceptor
implements XContextMenuInterceptor {
    private static Logger LOGGER = LoggerImpl.getLogger(ContextMenuInterceptor.class.getCanonicalName());

    public ContextMenuInterceptorAction notifyContextMenuExecute(ContextMenuExecuteEvent aEvent) throws RuntimeException {
        try {
            XIndexContainer xContextMenu = aEvent.ActionTriggerContainer;
            XMultiServiceFactory xMenuElementFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xContextMenu);
            if (xMenuElementFactory != null) {
                XPropertySet xRootMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                XPropertySet xSeparator = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerSeparator"));
                Short aSeparatorType = new Short(0);
                xSeparator.setPropertyValue("SeparatorType", (Object)aSeparatorType);
                xRootMenuEntry.setPropertyValue("Text", (Object)new String(I18nLabelsLoader.ADDON_REPORT_ERROR_CONTEXTMENU_GC));
                xRootMenuEntry.setPropertyValue("CommandURL", (Object)"org.cogroo.addon:ReportError");
                XPropertySet xMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                int last = xContextMenu.getCount();
                if (last < 0) {
                    last = 0;
                }
                xContextMenu.insertByIndex(last, (Object)xRootMenuEntry);
                xContextMenu.insertByIndex(last, (Object)xSeparator);
                return ContextMenuInterceptorAction.EXECUTE_MODIFIED;
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error initializing context menu interceptor");
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            LOGGER.warning("Error initializing context menu interceptor");
            ex.printStackTrace();
        }
        return ContextMenuInterceptorAction.IGNORED;
    }
}

