/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.dialogs.reporterror;

import com.sun.star.awt.XButton;
import com.sun.star.awt.XCheckBox;
import com.sun.star.awt.XComboBox;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.LoggerImpl;

public class DialogBuilder {
    protected static Logger LOGGER = LoggerImpl.getLogger(DialogBuilder.class.getCanonicalName());
    public static final int HORIZONTAL_ALIGNMENT_LEFT = 0;
    public static final int HORIZONTAL_ALIGNMENT_CENTER = 1;
    public static final int HORIZONTAL_ALIGNMENT_RIGHT = 2;
    private XMultiServiceFactory multiServiceFactory;
    private XComponentContext context;
    private Object oDialogModel;
    private XMultiComponentFactory multiComponentFactory;
    private XNameContainer nameContainer;
    private Object oUnoDialog;
    private XControl controller;
    private int tabcount = 0;
    protected XNameContainer m_xDlgModelNameContainer;
    protected XControlContainer m_xDlgContainer;
    private XMultiServiceFactory m_xMSFDialogModel = null;

    public DialogBuilder(XComponentContext context, int x, int y, int width, int height, String title) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(">>> DialogBuilder()");
        }
        this.context = context;
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(">>> DialogBuilder: will getServiceManager");
            }
            this.multiComponentFactory = this.context.getServiceManager();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(">>> DialogBuilder: will dialogModel");
            }
            this.oDialogModel = this.multiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialogModel", this.context);
            this.m_xDlgModelNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.oDialogModel);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(">>> DialogBuilder: will create dialogProperties");
            }
            XPropertySet dialogProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oDialogModel);
            dialogProperties.setPropertyValue("PositionX", (Object)new Integer(x));
            dialogProperties.setPropertyValue("PositionY", (Object)new Integer(y));
            dialogProperties.setPropertyValue("Width", (Object)new Integer(width));
            dialogProperties.setPropertyValue("Height", (Object)new Integer(height));
            dialogProperties.setPropertyValue("Title", (Object)title);
            dialogProperties.setPropertyValue("Sizeable", (Object)new Boolean(true));
            this.multiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.oDialogModel);
            this.nameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)this.oDialogModel);
            this.oUnoDialog = this.multiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialog", this.context);
            this.controller = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)this.oUnoDialog);
            XControlModel controlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)this.oDialogModel);
            this.controller.setModel(controlModel);
            this.m_xMSFDialogModel = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.oDialogModel);
            this.m_xDlgContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Uncaught exception", e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("<<< DialogBuilder()");
        }
    }

    public DialogBuilder(XComponentContext context, int x, int y, int width, int height, String title, int backgroundColor) {
        this(context, x, y, width, height, title);
        try {
            XPropertySet dialogProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oDialogModel);
            dialogProperties.setPropertyValue("BackgroundColor", (Object)new Integer(backgroundColor));
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
        }
    }

    public XButton addButton(String title, String name, int x, int y, int width, int height) throws Exception {
        Object buttonModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlButtonModel");
        XPropertySet buttonProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)buttonModel);
        buttonProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        buttonProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        buttonProperties.setPropertyValue("Width", (Object)new Integer(width));
        buttonProperties.setPropertyValue("Height", (Object)new Integer(height));
        buttonProperties.setPropertyValue("Name", (Object)name);
        buttonProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        buttonProperties.setPropertyValue("Label", (Object)title);
        this.nameContainer.insertByName(name, buttonModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl objectButton = controlContainer.getControl(name);
        XButton button = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)objectButton);
        return button;
    }

    public XFixedText addLabel(String text, String name, int x, int y, int width, int height) throws Exception {
        return this.addLabel(text, name, x, y, width, height, 0);
    }

    public XFixedText addLabel(String text, String name, int x, int y, int width, int height, int alignment) throws Exception {
        Object labelModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedTextModel");
        XPropertySet labelProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)labelModel);
        labelProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        labelProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        labelProperties.setPropertyValue("Width", (Object)new Integer(width));
        labelProperties.setPropertyValue("Height", (Object)new Integer(height));
        labelProperties.setPropertyValue("Align", (Object)new Short((short)alignment));
        labelProperties.setPropertyValue("Name", (Object)name);
        labelProperties.setPropertyValue("Label", (Object)text);
        this.nameContainer.insertByName(name, labelModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XFixedText field = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)obj);
        return field;
    }

    public XFixedText addMultiLineLabel(String text, String name, int x, int y, int width, int height) throws Exception {
        Object labelModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedTextModel");
        XPropertySet labelProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)labelModel);
        labelProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        labelProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        labelProperties.setPropertyValue("Width", (Object)new Integer(width));
        labelProperties.setPropertyValue("Height", (Object)new Integer(height));
        labelProperties.setPropertyValue("Name", (Object)name);
        labelProperties.setPropertyValue("MultiLine", (Object)new Boolean(true));
        labelProperties.setPropertyValue("Label", (Object)text);
        this.nameContainer.insertByName(name, labelModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XFixedText field = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)obj);
        return field;
    }

    public XListBox addListBox(String[] items, String name, int x, int y, int width, int height) throws Exception {
        Object listModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlListBoxModel");
        XPropertySet listProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)listModel);
        listProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        listProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        listProperties.setPropertyValue("Width", (Object)new Integer(width));
        listProperties.setPropertyValue("Height", (Object)new Integer(height));
        listProperties.setPropertyValue("Border", (Object)new Short(2));
        listProperties.setPropertyValue("Name", (Object)name);
        listProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        listProperties.setPropertyValue("StringItemList", (Object)items);
        this.nameContainer.insertByName(name, listModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XListBox lbox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)obj);
        return lbox;
    }

    public XComboBox addComboBox(String[] items, String name, int x, int y, int width, int height) throws Exception {
        Object comboBoxModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlComboBoxModel");
        XPropertySet listProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)comboBoxModel);
        listProperties.setPropertyValue("Dropdown", (Object)Boolean.TRUE);
        listProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        listProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        listProperties.setPropertyValue("Width", (Object)new Integer(width));
        listProperties.setPropertyValue("Height", (Object)new Integer(height));
        listProperties.setPropertyValue("Border", (Object)new Short(2));
        listProperties.setPropertyValue("Name", (Object)name);
        listProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        listProperties.setPropertyValue("ReadOnly", (Object)Boolean.TRUE);
        listProperties.setPropertyValue("StringItemList", (Object)items);
        this.nameContainer.insertByName(name, comboBoxModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XComboBox lbox = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)obj);
        return lbox;
    }

    public XTextComponent addTextField(String content, String name, int x, int y, int width, int height) throws Exception {
        Object labelModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlEditModel");
        XPropertySet textFieldProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)labelModel);
        textFieldProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        textFieldProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        textFieldProperties.setPropertyValue("Width", (Object)new Integer(width));
        textFieldProperties.setPropertyValue("Height", (Object)new Integer(height));
        textFieldProperties.setPropertyValue("Name", (Object)name);
        textFieldProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        textFieldProperties.setPropertyValue("MultiLine", (Object)new Boolean(false));
        textFieldProperties.setPropertyValue("Text", (Object)content);
        this.nameContainer.insertByName(name, labelModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XTextComponent field = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)obj);
        return field;
    }

    public XTextComponent addTextArea(String content, String name, int x, int y, int width, int height) throws Exception {
        Object labelModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlEditModel");
        XPropertySet textAreaProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)labelModel);
        textAreaProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        textAreaProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        textAreaProperties.setPropertyValue("Width", (Object)new Integer(width));
        textAreaProperties.setPropertyValue("Height", (Object)new Integer(height));
        textAreaProperties.setPropertyValue("Name", (Object)name);
        textAreaProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        textAreaProperties.setPropertyValue("MultiLine", (Object)new Boolean(true));
        textAreaProperties.setPropertyValue("HScroll", (Object)new Boolean(false));
        textAreaProperties.setPropertyValue("VScroll", (Object)new Boolean(false));
        textAreaProperties.setPropertyValue("Text", (Object)content);
        this.nameContainer.insertByName(name, labelModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XTextComponent field = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)obj);
        return field;
    }

    public XTextComponent addTextArea(String content, String name, int x, int y, int width, int height, boolean readonly) throws Exception {
        Object labelModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlEditModel");
        XPropertySet textAreaProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)labelModel);
        textAreaProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        textAreaProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        textAreaProperties.setPropertyValue("Width", (Object)new Integer(width));
        textAreaProperties.setPropertyValue("Height", (Object)new Integer(height));
        textAreaProperties.setPropertyValue("Name", (Object)name);
        textAreaProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        textAreaProperties.setPropertyValue("MultiLine", (Object)new Boolean(true));
        textAreaProperties.setPropertyValue("ReadOnly", (Object)new Boolean(readonly));
        textAreaProperties.setPropertyValue("Text", (Object)content);
        this.nameContainer.insertByName(name, labelModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XTextComponent field = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)obj);
        return field;
    }

    public XTextComponent addPasswordField(char[] password, String name, int x, int y, int width, int height) throws Exception {
        Object labelModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlEditModel");
        XPropertySet passwordFieldProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)labelModel);
        passwordFieldProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        passwordFieldProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        passwordFieldProperties.setPropertyValue("Width", (Object)new Integer(width));
        passwordFieldProperties.setPropertyValue("Height", (Object)new Integer(height));
        passwordFieldProperties.setPropertyValue("Name", (Object)name);
        passwordFieldProperties.setPropertyValue("TabIndex", (Object)new Short((short)this.tabcount++));
        passwordFieldProperties.setPropertyValue("MultiLine", (Object)new Boolean(false));
        passwordFieldProperties.setPropertyValue("EchoChar", (Object)new Short(42));
        passwordFieldProperties.setPropertyValue("Text", (Object)new String(password));
        for (int i = 0; i < password.length; ++i) {
            password[i] = 12;
        }
        this.nameContainer.insertByName(name, labelModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XTextComponent field = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)obj);
        return field;
    }

    public void addImage(String url, String name, int x, int y, int width, int height, boolean scale) throws Exception {
        Object imageModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlImageControlModel");
        XPropertySet imageProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)imageModel);
        imageProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        imageProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        imageProperties.setPropertyValue("Width", (Object)new Integer(width));
        imageProperties.setPropertyValue("Height", (Object)new Integer(height));
        imageProperties.setPropertyValue("Name", (Object)name);
        imageProperties.setPropertyValue("ScaleImage", (Object)new Boolean(scale));
        imageProperties.setPropertyValue("ImageURL", (Object)new String(url));
        this.nameContainer.insertByName(name, imageModel);
    }

    public void addImage(String url, String name, int x, int y, int width, int height, boolean scale, short border) throws Exception {
        Object imageModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlImageControlModel");
        XPropertySet imageProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)imageModel);
        imageProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        imageProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        imageProperties.setPropertyValue("Width", (Object)new Integer(width));
        imageProperties.setPropertyValue("Height", (Object)new Integer(height));
        imageProperties.setPropertyValue("Name", (Object)name);
        imageProperties.setPropertyValue("ScaleImage", (Object)new Boolean(scale));
        imageProperties.setPropertyValue("ImageURL", (Object)new String(url));
        imageProperties.setPropertyValue("Border", (Object)new Short(border));
        this.nameContainer.insertByName(name, imageModel);
    }

    public XCheckBox addCheckBox(boolean state, String name, int x, int y, int width, int height) throws Exception {
        Object checkboxModel = this.multiServiceFactory.createInstance("com.sun.star.awt.UnoControlCheckBoxModel");
        XPropertySet imageProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)checkboxModel);
        imageProperties.setPropertyValue("PositionX", (Object)new Integer(x));
        imageProperties.setPropertyValue("PositionY", (Object)new Integer(y));
        imageProperties.setPropertyValue("Width", (Object)new Integer(width));
        imageProperties.setPropertyValue("Height", (Object)new Integer(height));
        imageProperties.setPropertyValue("Name", (Object)name);
        short value = 0;
        if (state) {
            value = 1;
        }
        imageProperties.setPropertyValue("State", (Object)new Short(value));
        this.nameContainer.insertByName(name, checkboxModel);
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XControl obj = controlContainer.getControl(name);
        XCheckBox checkbox = (XCheckBox)UnoRuntime.queryInterface(XCheckBox.class, (Object)obj);
        return checkbox;
    }

    public XDialog getDialog() {
        try {
            Object toolkit = this.multiComponentFactory.createInstanceWithContext("com.sun.star.awt.Toolkit", this.context);
            XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)toolkit);
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.controller);
            xWindow.setVisible(false);
            this.controller.createPeer(xToolkit, null);
            return (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)this.oUnoDialog);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void dispose(XDialog dialog) {
        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)dialog);
        xComponent.dispose();
    }

    public XNameContainer getModelContainer() {
        return this.nameContainer;
    }

    public String getTextContent(String componentName) throws NoSuchElementException, WrappedTargetException {
        XControlContainer controlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.oUnoDialog);
        XTextComponent textComp = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)controlContainer.getControl(componentName));
        return textComp.getText();
    }

    public static String createUniqueName(XNameAccess _xElementContainer, String _sElementName) {
        boolean bElementexists = true;
        int i = 1;
        String sIncSuffix = "";
        String BaseName = _sElementName;
        while (bElementexists) {
            bElementexists = _xElementContainer.hasByName(_sElementName);
            if (!bElementexists) continue;
            _sElementName = BaseName + Integer.toString(++i);
        }
        return _sElementName;
    }
}

