/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.addon.dialogs.reporterror;

import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cogroo.addon.LoggerImpl;
import org.cogroo.addon.dialogs.MessageBox;
import org.cogroo.addon.dialogs.reporterror.ErrorReportDialog;
import org.cogroo.addon.i18n.I18nLabelsLoader;

public class ErrorReportDialogThread
extends Thread {
    protected static Logger LOGGER = LoggerImpl.getLogger(ErrorReportDialogThread.class.getCanonicalName());
    private XComponentContext xCompContext;
    private String text;

    public void setText(String aText) {
        this.text = aText;
    }

    public ErrorReportDialogThread(XComponentContext xCompContext) {
        LOGGER.fine("Called ReportError constructor.");
        this.xCompContext = xCompContext;
    }

    public void run() {
        short result;
        MessageBox mb;
        LOGGER.fine("Called ErrorReportDialogThread run().");
        if (this.text == null || this.text.length() == 0) {
            LOGGER.fine("Text was null or empty. Will return.");
            MessageBox mb2 = new MessageBox(this.xCompContext);
            mb2.showMessageBox(I18nLabelsLoader.ADDON_REPORT_ERROR_SELECTION_EMPTY_HEADER, I18nLabelsLoader.ADDON_REPORT_ERROR_SELECTION_EMPTY_BODY, "warningbox", 1);
            return;
        }
        if (this.text.length() > 255) {
            LOGGER.fine("Text too long: " + this.text.length());
            mb = new MessageBox(this.xCompContext);
            result = mb.showMessageBox(I18nLabelsLoader.ADDON_REPORT_ERROR_SELECTION_TOO_LONG_HEADER, I18nLabelsLoader.ADDON_REPORT_ERROR_SELECTION_TOO_LONG_BODY, "warningbox", 2);
            if (result != 1) {
                LOGGER.fine("User canceled");
                return;
            }
            this.text = this.text.substring(0, 255);
            LOGGER.fine("Result: " + result);
        }
        if (this.text.split("\\s+").length < 3) {
            LOGGER.fine("Text too short: " + this.text.length());
            mb = new MessageBox(this.xCompContext);
            result = mb.showMessageBox(I18nLabelsLoader.ADDON_REPORT_ERROR_SELECTION_TOO_SHORT_HEADER, I18nLabelsLoader.ADDON_REPORT_ERROR_SELECTION_TOO_SHORT_BODY + " \"" + this.text + "\"", "warningbox", 2);
            if (result != 1) {
                LOGGER.fine("User canceled");
                return;
            }
            LOGGER.fine("Result: " + result);
        }
        ErrorReportDialog errorReportDialog = null;
        try {
            LOGGER.fine("Will create UnoDialogSample dialog");
            errorReportDialog = new ErrorReportDialog(this.xCompContext, this.xCompContext.getServiceManager());
            errorReportDialog.initialize(this.text);
            errorReportDialog.executeDialog();
            LOGGER.fine("Finished");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Uncaught exception", e);
        }
        finally {
            if (errorReportDialog != null && errorReportDialog.m_xComponent != null) {
                errorReportDialog.m_xComponent.dispose();
            }
        }
    }
}

